package gov.va.nvap.svc.consentmgmt;

import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.Announcement;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementOrg;

import java.util.List;

/**
 * 
 * @author Zack Peterson
 */
public interface AnnouncementOrgControllerInterface {

	void create(AnnouncementOrg announcementOrg) throws PreexistingEntityException,
			Exception;

	void edit(AnnouncementOrg announcementOrg) throws NonexistentEntityException,
			Exception;
    
    void removeByAnnouncement (Announcement announcement);

	AnnouncementOrg findAnnouncementOrgById(Long id);

	List<AnnouncementOrg> findAllAnnouncementOrgs();
    
    public List<AnnouncementOrg> findAnnouncementOrgsByAnnouncement(final Announcement announcement);
    
    public List<AnnouncementBatchSummary> retrieveBatchSummaries (final List<String> batchIds);
}
