/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.svc.consenteval.jee.wrapper;


import gov.va.nvap.server.auth.ServiceAuthentication;
import gov.va.nvap.service.auth.ServiceAudit;
import gov.va.nvap.service.auth.ServiceAuthenticationException;
import gov.va.nvap.svc.consenteval.intf.PolicyEvaluationService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;

import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.WebServiceContext;


import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 * 
 * @author Anand Sastry
 */
@Stateless
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
//@WebService(serviceName = "XACMLContextHandlerService", portName = "XACMLContextHandlerPort", name = "XACMLContextHandlerPortType", wsdlLocation = "META-INF/xml-resources/web-services/XACMLContextHandlerService/wsdl/XACMLContextHandlerService.wsdl")
@WebService(serviceName = "PolicyEvaluationServiceWS", portName = "PolicyEvaluationServicePort", name = "PolicyEvaluationServicePortType", wsdlLocation = "META-INF/xml-resources/web-services/PolicyEvaluationServiceWS/wsdl/PolicyEvaluationServiceWS.wsdl")
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class PolicyEvaluationServiceWS  implements PolicyEvaluationService {

	/**
	 * Inject Spring bean, so that we have all dependencies injected.
	 */
	@Autowired
	@Qualifier(value = "PolicyEvaluationSvc")
	private PolicyEvaluationService policyEvaluationService;
        @Autowired
        private ApplicationContext applicationContext;
        @Resource
        private WebServiceContext context;
        private final ServiceAuthentication auth = new ServiceAuthentication();
	/**
	 * @param request
	 * @return
	 */
	@WebMethod
    @Override
	public ResponseType checkPolicy(final RequestType request) {
        ServiceAudit sa;
        Integer success = 1;

        try {
            sa = auth.checkAuth(context, applicationContext, "checkPolicy");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }

        ResponseType response = null;
        long startTime = System.currentTimeMillis();

        try {
            response = policyEvaluationService.checkPolicy(request);
        } catch (Exception e) {
            success = 0;
        } finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }

        return response;
	}

}
