package gov.va.nvap.svc.consenteval.jee.wrapper;

import gov.va.nvap.privacy.ConsentManagementServiceFaultType;
import gov.va.nvap.svc.consenteval.intf.PolicyEvaluationServiceException;

import javax.xml.ws.WebFault;

@WebFault(name = "PolicyEvaluationServiceFault", targetNamespace = "http://gov.va.nvap.svc.consenteval.jee.wrapper/")
public class PolicyEvaluationServiceFaultMessage extends
		PolicyEvaluationServiceException {

	/**
	 * Serial UID.
	 */
	private static final long serialVersionUID = 5073017128656822920L;
	/**
	 * Java type that goes as soapenv:Fault detail element.
	 */
	private final ConsentManagementServiceFaultType faultInfo;

	/**
	 * @param message
	 * @param faultInfo
	 */
	public PolicyEvaluationServiceFaultMessage(final String message,
			final ConsentManagementServiceFaultType faultInfo) {
		super(message);
		this.faultInfo = faultInfo;
	}

	/**
	 * @param message
	 * @param faultInfo
	 * @param cause
	 */
	public PolicyEvaluationServiceFaultMessage(final String message,
			final ConsentManagementServiceFaultType faultInfo,
			final Throwable cause) {
		super(message, cause);
		this.faultInfo = faultInfo;
	}

	/**
	 * @return returns fault bean:
	 *         gov.va.nvap.privacy.ConsentManagementServiceFaultType
	 */
	public ConsentManagementServiceFaultType getFaultInfo() {
		return this.faultInfo;
	}

}
