package gov.va.nvap.service.permission;


import oasis.names.tc.xacml._2_0.context.schema.os.DecisionType;
import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import junit.framework.Assert;

import gov.va.nvap.server.service.permission.pdp.PDPImplJava;

public class SimplePDPTester {
	
	private PDPImplJava simplePDP = new PDPImplJava();
	
	public SimplePDPTester() {
		simplePDP.setLocalHomeCommunityId("2.16.840.1.113883.4.349");
		simplePDP.setNoOptInRequiredHomeCommunities(new String[] {"2.16.840.1.113883.3.42.10001.100001.12"});
		simplePDP.setPatientPurposeOfUse(new String[] {"TREATMENT","EMERGENCY"});
	}

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
	}

	@After
	public void tearDown() throws Exception {
	}
	
	/* -----------------------
	 * Valid Request Types 
	 * -----------------------
	 */
	
	
	@Test
	public void testValidInboundDocQueryInByDODRequestorNoOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildValidInboundDocQueryInByDODRequestorNoOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Valid Inbound Doc Query By DOD Requestor - not opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.PERMIT);
	}
	
	@Test
	public void testValidInboundDocQueryInByDODRequestorWithOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildValidInboundDocQueryInByDODRequestorWithOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Valid Inbound Doc Query By DOD Requestor - opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.PERMIT);
	}


	@Test
	public void testValidInboundDocQueryInByNonDODRequestorWithOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildValidInboundDocQueryInByNonDODRequestorWithOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Valid Inbound Doc Query By Non DOD Requestor - opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.PERMIT);
	}
	
	@Test
	public void testValidInboundDocRetrieveInByNonDODRequestorWithOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildValidInboundDocRetrieveInByNonDODRequestorWithOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Valid Inbound Doc Retrieve By Non DOD Requestor - opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.PERMIT);
	}
	
	@Test
	public void testValidInboundPatientDiscoveryInByNonDODRequestorWithOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildValidInboundPatientDiscoveryInByNonDODRequestorWithOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Valid Inbound Patient Discovery By Non DOD Requestor - opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.PERMIT);
	}


	@Test
	public void testValidOutboundDocQueryOutByDODRequestorNoOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildValidOutboundDocQueryOutByDODRequestorNoOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Valid Outbound Doc Query By DOD Requestor - not opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.PERMIT);
	}
	
	@Test
	public void testValidOutboundDocQueryOutByDODRequestorWithOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildValidOutboundDocQueryOutByDODRequestorWithOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Valid Outbound Doc Query By DOD Requestor - opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.PERMIT);
	}
	
	@Test
	public void testValidOutboundDocQueryOutByNonDODRequestorWithOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildValidOutboundDocQueryOutByNonDODRequestorWithOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Valid Outbound Doc Query By Non DOD Requestor - opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.PERMIT);
	}

	@Test
	public void testValidOutboundDocRetrieveOutByNonDODRequestorWithOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildValidOutboundDocRetrieveOutByNonDODRequestorWithOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Valid Outbound Doc Retrieve By Non DOD Requestor - opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.PERMIT);
	}
	
	@Test
	public void testValidOutboundPatientDiscoveryOutByNonDODRequestorWithOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildValidOutboundPatientDiscoveryOutByNonDODRequestorWithOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Valid Outbound Patient Discovery By Non DOD Requestor - opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.PERMIT);
	}
	
	

	/* -----------------------
	 * In Valid Request Types 
	 * -----------------------
	 */


	@Test
	public void testInvalidInboundDocQueryInByNonDODRequestorEmptyOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildInvalidInboundDocQueryInByNonDODRequestorEmptyOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("InValid Inbound Doc Query By Non DOD Requestor - not opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.DENY);
	}
	
	@Test
	public void testInvalidInboundDocQueryInByNonDODRequestorNoOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildInvalidInboundDocQueryInByNonDODRequestorNoOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("InValid Inbound Doc Query By Non DOD Requestor - not opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.DENY);
	}

	

	@Test
	// OptIn/Out evaluated only for PD - Validate this
	public void testInvalidOutboundDocQueryOutByNonDODRequestorEmptyOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildInvalidOutboundDocQueryOutByNonDODRequestorEmptyOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("InValid Outbound Doc Query ?? By Non DOD Requestor - not opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.PERMIT);
	}
	// OptIn/Out evaluated only for PD - Validate this
	@Test
	public void testInvalidDocQueryOutByNonDODRequestorNoOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildInvalidOutboundDocQueryOutByNonDODRequestorNoOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("InValid Outbound Doc Query ?? By Non DOD Requestor - not opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.PERMIT);
	}

	@Test
	public void testInvalidOutboundPatientDiscoveryOutByNonDODRequestorEmptyOptIn() {
		RequestType request = SampleXACMLRequestBuilder.buildInvalidOutboundPatientDiscoveryOutByNonDODRequestorEmptyOptIn();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("InValid Outbound Patient Discovery By Non DOD Requestor - not opted in", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.DENY);
	}

	/*
	 * This tests out the condition of a null input namely, the request.
	 * Expected response is a Deny
	 */
	
	@Test
	public void testWithNullRequest() {
		//Null Request
		ResponseType response = simplePDP.checkPolicy(null);
		Assert.assertTrue("Null request resulted in a Deny", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.DENY);
	}

	@Test
	public void testMissingRequestorActionInRequest() {
		RequestType request = SampleXACMLRequestBuilder.buildRequestWithoutAction();
		
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Null request resulted in a Deny", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.DENY);
	}

	@Test
	public void testUnsupportedRequestorActionInRequest() {
		RequestType request = SampleXACMLRequestBuilder.buildRequestWithUnsupportedAction();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Null request resulted in a Deny", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.DENY);
	}
		
	@Test
	public void testMissingRequestorHomeCommunityIdInRequest() {
		RequestType request = SampleXACMLRequestBuilder.buildWithoutHCID();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Null request resulted in a Deny", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.DENY);
	}
	
	@Test
	public void testMissingRequestorPatientIdInRequest() {
		RequestType request = SampleXACMLRequestBuilder.buildWithoutPatientId();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Null request resulted in a Deny", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.DENY);
	}
	
	@Test
	public void testMissingPOU() {
		RequestType request = SampleXACMLRequestBuilder.buildRequestWithMissingPOU();
		ResponseType response = simplePDP.checkPolicy(request);
		Assert.assertTrue("Null request resulted in a Deny", 
				response.getResult().get(0).getDecision() ==
			    DecisionType.DENY);
	}

}
