/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.service.permission;



import gov.va.nvap.server.service.permission.common.XACMLContextConstants;
import gov.va.nvap.server.service.permission.common.XACMLContextUtil;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;

import oasis.names.tc.xacml._2_0.context.schema.os.ActionType;
import oasis.names.tc.xacml._2_0.context.schema.os.AttributeType;
import oasis.names.tc.xacml._2_0.context.schema.os.AttributeValueType;
import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResourceType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;
import oasis.names.tc.xacml._2_0.context.schema.os.SubjectType;

/**
 *
 * @author Anand Sastry
 */
public class SampleXACMLRequestBuilder
{
   private static final String ACTION_ATTRIBUTE_ID = "urn:oasis:names:tc:xacml:1.0:action:action-id";
   private static final String SUBJECT_HOME_COMMUNITY_ATTRIBUTE_ID = "http://www.hhs.gov/healthit/nhin#HomeCommunityId";
   private static final String RESOURCE_HOME_COMMUNITY_ATTRIBUTE_ID = "urn:gov:hhs:fha:nhinc:home-community-id";
   private static final String SUBJECT_PURPOSE_FOR_USE_ATTRIBUTE_ID = "urn:oasis:names:tc:xspa:1.0:subject:purposeofuse";
   private static final String SUBJECT_SUBJECT_ID_ATTRIBUTE_ID = "urn:oasis:names:tc:xacml:1.0:subject:subject-id";
   private static final String RESOURCE_ATTRIBUTE_ID = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";

    public static RequestType buildNHINOutCheckPolicyRequest()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "NHINOut");

        setRequestorSubject(requestType, "TestUser", "");

        return requestType;
    }
    
    public static RequestType buildBasicValidInboundDocQueryInByDODRequestor()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "123457", "2.16.840.1.113883.3.42.10001.100001.12");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    public static RequestType buildValidInboundDocQueryInByRequestorInPatientExcludedOrganization()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "123457", "2.16.840.1.113883.3.715");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidInboundDocQueryInByRequestorInPatientAllowedOrganization()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "123457", "2.16.840.1.113883.3.424");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidInboundDocQueryInByNonDODRequestorPatientOptedOut()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "123459", "2.16.840.1.113883.3.424");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidInboundDocQueryInByDODRequestorPatientOptedOut()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "123459", "2.16.840.1.113883.3.42.10001.100001.12");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidInboundDocQueryOutByRequestorInPatientAllowedOrganization()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryOut");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "123457", "2.16.840.1.113883.3.424");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidInboundDocRetrieveInByRequestorInPatientAllowedOrganization()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentRetrieveIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "123457", "2.16.840.1.113883.3.424");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidInboundDocRetrieveOutByRequestorInPatientAllowedOrganization()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentRetrieveOut");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "123457", "2.16.840.1.113883.3.424");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidInboundPatientDiscoveryInByRequestorInPatientAllowedOrganization()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "PatientDiscoveryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "123457", "2.16.840.1.113883.3.424");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidInboundPatientDiscoveryOutByRequestorInPatientAllowedOrganization()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "PatientDiscoveryOut");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "123457", "2.16.840.1.113883.3.424");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildNHINOutWithValidOrgId()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "NHINOut");

        setRequestorSubject(requestType, "983:1234", "TREATMENT");

        setRequestorResource(requestType, "", "2.16.840.1.113883.3.424");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildNHINOutWithInValidOrgId()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "NHINOut");

        setRequestorSubject(requestType, "943:1234", "TREATMENT");

        setRequestorResource(requestType, "", "2.16.840.1.113883.3.424");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
   
    public static RequestType buildDocQueryInByDODRequestorWithInvalidPatient()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "123", "2.16.840.1.113883.3.42.10001.100001.12");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildDocQueryInByDODRequestorWithMissingPatient()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        String patient = null;
        setRequestorResource(requestType, patient, "2.16.840.1.113883.3.42.10001.100001.12");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildDocQueryInByDODRequestorWithMissingAction()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        String patient = null;
        setRequestorResource(requestType, patient, "2.16.840.1.113883.3.42.10001.100001.12");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildDocQueryInByDODRequestorWithMissingPOU()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "");

        setRequestorResource(requestType, "123456", "2.16.840.1.113883.3.42.10001.100001.12");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildDocQueryInByDODRequestorWithInvalidPOU()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "INVALIDPOU");

        setRequestorResource(requestType, "123456", "2.16.840.1.113883.3.42.10001.100001.12");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildDocQueryInByDODRequestorWithMissingHCID()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "123456", "");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildDocQueryInByDODRequestorWithUnsupportedHCID()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "123456", "1.2.3");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    
    public static RequestType buildDocQueryInByDODRequestorWithUnsupportedAction()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "Unsupported");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "123456", "2.16.840.1.113883.3.42.10001.100001.12");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }


    public static RequestType buildPatientDiscoveryOutCheckPolicyRequest(String userId, String patientId, String pou, String hcid)
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "PatientDiscoveryOut");

        setRequestorSubject(requestType, userId, pou);

        setRequestorResource(requestType, patientId, hcid);

        return requestType;
    }

    public static RequestType buildDocumentQueryOutCheckPolicyRequest(String userId, String patientId, String pou, String hcid)
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryOut");

        setRequestorSubject(requestType, userId, pou);

        setRequestorResource(requestType, patientId, hcid);

        return requestType;
    }
    
    public static RequestType buildValidInboundDocQueryInByDODRequestorNoOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.42.10001.100001.12");
       
        //DOD opt-in not specified
        
        setAllowedHCIDs(requestType);
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidOutboundDocQueryOutByDODRequestorNoOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryOut");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.42.10001.100001.12");
       
        //DOD opt-in not specified
        
        setAllowedHCIDs(requestType);
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidInboundDocQueryInByDODRequestorWithOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.42.10001.100001.12");
       
        //DOD opt-in specified
        
        setAllowedHCIDs(requestType);
        
        setOptIn(requestType, "YES");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidOutboundDocQueryOutByDODRequestorWithOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryOut");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.42.10001.100001.12");
       
        //DOD opt-in specified
        
        setAllowedHCIDs(requestType);
        
        setOptIn(requestType, "YES");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    
    public static RequestType buildValidInboundDocQueryInByNonDODRequestorWithOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.488.1");
       
        //DOD opt-in specified
        
        setAllowedHCIDs(requestType);
        
        setOptIn(requestType, "YES");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidOutboundDocQueryOutByNonDODRequestorWithOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryOut");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.488.1");
       
        //DOD opt-in specified
        
        setAllowedHCIDs(requestType);
        
        setOptIn(requestType, "YES");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidInboundDocRetrieveInByNonDODRequestorWithOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentRetrieveIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.488.1");
       
        //DOD opt-in specified
        
        setAllowedHCIDs(requestType);
        
        setOptIn(requestType, "YES");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidOutboundDocRetrieveOutByNonDODRequestorWithOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentRetrieveOut");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.488.1");
       
        //DOD opt-in specified
        
        setAllowedHCIDs(requestType);
        
        setOptIn(requestType, "YES");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidInboundPatientDiscoveryInByNonDODRequestorWithOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "PatientDiscoveryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.488.1");
       
        //DOD opt-in specified
        
        setAllowedHCIDs(requestType);
        
        setOptIn(requestType, "YES");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildValidOutboundPatientDiscoveryOutByNonDODRequestorWithOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "PatientDiscoveryOut");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.488.1");
       
        //DOD opt-in specified
        
        setAllowedHCIDs(requestType);
        
        setOptIn(requestType, "YES");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildInvalidInboundDocQueryInByNonDODRequestorEmptyOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.488.1");
       
        //DOD opt-in not specified
        
        setAllowedHCIDs(requestType);
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildInvalidOutboundDocQueryOutByNonDODRequestorEmptyOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryOut");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.488.1");
       
        //DOD opt-in not specified
        
        setAllowedHCIDs(requestType);
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildInvalidOutboundPatientDiscoveryOutByNonDODRequestorEmptyOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "PatientDiscoveryOut");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.488.1");
       
        //DOD opt-in not specified
        
        setAllowedHCIDs(requestType);
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildInvalidInboundDocQueryInByNonDODRequestorNoOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryIn");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.488.1");
       
        //DOD opt-in not specified
        
        setAllowedHCIDs(requestType);
        
        setOptIn(requestType, "NO");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildInvalidOutboundDocQueryOutByNonDODRequestorNoOptIn()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "DocumentQueryOut");

        setRequestorSubject(requestType, "UserId-Does-Not-Matter-For-This-txn", "TREATMENT");

        setRequestorResource(requestType, "patientId", "2.16.840.1.113883.3.488.1");
       
        //DOD opt-in not specified
        
        setAllowedHCIDs(requestType);
        
        setOptIn(requestType, "NO");
        
        dumpRequestContents("RequestType", requestType);
        
        return requestType;
    }
    
    public static RequestType buildRequestWithoutAction()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        return requestType;
    }
    
    public static RequestType buildRequestWithUnsupportedAction()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "Unsupported");
        setRequestorSubject(requestType, "TestUser", "PurposeOfUse");
        return requestType;
    }
    
    public static RequestType buildRequestWithMissingPOU()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setAction(requestType, "Unsupported");
        setRequestorSubject(requestType, "TestUser", "");
        return requestType;
    }
    
    public static RequestType buildWithoutHCID()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setRequestorSubject(requestType, "TestUser", "TREATMENT");

        setRequestorResource(requestType, "patientId", "");
        
        return requestType;
    }
    
    public static RequestType buildWithoutPatientId()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setRequestorSubject(requestType, "TestUser", "TREATMENT");

        setRequestorResource(requestType, "", "HCID");
        
        return requestType;
    }
    
    
    public static RequestType buildWithoutPOU()
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType requestType = objFactory.createRequestType();

        setRequestorSubject(requestType, "TestUser", "");

        setRequestorResource(requestType, "patientId", "HCID");
        
        return requestType;
    }
    
    private static void setAction(RequestType requestType, String action) {
        AttributeValueType actionAttributeValue = new AttributeValueType();
        actionAttributeValue.getContent().add(action);

        AttributeType actionAttribute = new AttributeType();
        actionAttribute.setAttributeId(ACTION_ATTRIBUTE_ID);
        actionAttribute.getAttributeValue().add(actionAttributeValue);

        ActionType actionType = new ActionType();
        actionType.getAttribute().add(actionAttribute);
        
        requestType.setAction(actionType);
    }
    
    
    private static void setRequestorSubject(RequestType requestType, 
    		String userId, String pou) {
    	SubjectType subject = new SubjectType();
    	if (userId != null && userId.trim().length() > 0) {
        	AttributeValueType subjectUserIdAttributeValue = new AttributeValueType();
            subjectUserIdAttributeValue.getContent().add(userId);

            AttributeType subjectUserIdAttribute = new AttributeType();
            subjectUserIdAttribute.setAttributeId(SUBJECT_SUBJECT_ID_ATTRIBUTE_ID);
            subjectUserIdAttribute.getAttributeValue().add(subjectUserIdAttributeValue);
            
            subject.getAttribute().add(subjectUserIdAttribute);
    	}

        
        if (pou != null && pou.trim().length() > 0) {
            AttributeValueType subjectPurposeForUseAttributeValue = new AttributeValueType();
            subjectPurposeForUseAttributeValue.getContent().add(pou);

            AttributeType subjectPurposeForUseAttribute = new AttributeType();
            subjectPurposeForUseAttribute.setAttributeId(SUBJECT_PURPOSE_FOR_USE_ATTRIBUTE_ID);
            subjectPurposeForUseAttribute.getAttributeValue().add(subjectPurposeForUseAttributeValue);

            subject.getAttribute().add(subjectPurposeForUseAttribute);
        }

        
        requestType.getSubject().add(subject);
    }
    
    private static void setRequestorResource(RequestType requestType, 
    		String patientId, String hcid) {
    	ResourceType resource = new ResourceType();
    	if (patientId != null && patientId.trim().length() > 0) {
    		AttributeValueType resourcePatientIdAttributeValue = new AttributeValueType();
            resourcePatientIdAttributeValue.getContent().add(patientId);

            AttributeType resourcePatientIdAttribute = new AttributeType();
            resourcePatientIdAttribute.setAttributeId(RESOURCE_ATTRIBUTE_ID);
            resourcePatientIdAttribute.getAttributeValue().add(resourcePatientIdAttributeValue);
            
            resource.getAttribute().add(resourcePatientIdAttribute);
    	}
    	
    	if (hcid != null && hcid.trim().length() > 0) {

            AttributeValueType resourceHomeCommunityIdAttributeValue = new AttributeValueType();
            resourceHomeCommunityIdAttributeValue.getContent().add(hcid);

            AttributeType resourceHomeCommunityIdAttribute = new AttributeType();
            resourceHomeCommunityIdAttribute.setAttributeId(RESOURCE_HOME_COMMUNITY_ATTRIBUTE_ID);
            resourceHomeCommunityIdAttribute.getAttributeValue().add(resourceHomeCommunityIdAttributeValue);

      
            resource.getAttribute().add(resourceHomeCommunityIdAttribute);
    	}
        


        requestType.getResource().add(resource);
    }
    
    private static void setAllowedHCIDs(RequestType request) {
    	List<String> patientAllowedOrgs = new ArrayList<String>();
    	patientAllowedOrgs.add("2.16.840.1.113883.3.190.6.100.1");
    	patientAllowedOrgs.add("1.3.6.1.4.1.26580");
    	patientAllowedOrgs.add("2.16.840.1.113883.3.715");
    	patientAllowedOrgs.add("2.16.840.1.113883.3.488.1");
    	//even DOD has to be allowed
    	patientAllowedOrgs.add("2.16.840.1.113883.3.42.10001.100001.12");

		XACMLContextUtil.addResourceAttributeValues(
				XACMLContextConstants.RESOURCE_PATIENT_ALLOWED_ORGS_ATTR_ID,
				XACMLContextConstants.STRING_ATTR_DATA_TYPE, 
				patientAllowedOrgs, request);
    	}
    
    private static void setOptIn(RequestType request, String value) {
    	XACMLContextUtil.addResourceAttributeValue(
    			XACMLContextConstants.RESOURCE_OPTIN_ATTR_ID,
    			XACMLContextConstants.STRING_ATTR_DATA_TYPE, 
    			value, request);
    	}
    private static void dumpRequestContents(String context, RequestType req) {
		try {
			JAXBContext jaxbContext = JAXBContext.newInstance(RequestType.class);
			Marshaller m = jaxbContext.createMarshaller();
		    m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);

		    System.out.println(context + " <<<" );
		   // m.marshal(req, System.out);

		    m.marshal( new JAXBElement(
		    		  new QName("uri","local"), RequestType.class, req ), System.out);
		    System.out.println(context + " >>>" );
		} catch (JAXBException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		

	}
	
	private void dumpRsponseContents(String context, ResponseType req) {
		try {
			JAXBContext jaxbContext = JAXBContext.newInstance(ResponseType.class);
			Marshaller m = jaxbContext.createMarshaller();
		    m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);

		    System.out.println(context + " <<<" );
		   // m.marshal(req, System.out);

		    m.marshal( new JAXBElement(
		    		  new QName("uri","local"), ResponseType.class, req ), System.out);
		    System.out.println(context + " >>>" );
		} catch (JAXBException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
