package gov.va.nvap.server.test.service.facility;

import gov.va.nvap.svc.facility.intf.EntityDoesNotExistException;
import gov.va.nvap.svc.facility.intf.FacilityService;

import gov.va.nvap.svc.facility.data.Facility;
import gov.va.nvap.svc.facility.data.Location;

import java.util.ArrayList;
import java.util.Collection;

public class MockFacilityService implements FacilityService {

    Collection<Facility> allFacilities;
    Collection<Facility> allowedFacilities;
    Facility fac1 = new Facility();

    public MockFacilityService() {

    	fac1.setAllowed(true);
    	fac1.setFacilityId(new Long(101));
    	fac1.setFacilityName("VA Facility 1");
    	fac1.setFacilityStation("998");
    	
    	Facility fac2 = new Facility();
    	fac2.setAllowed(false);
    	fac2.setFacilityId(new Long(102));
    	fac2.setFacilityName("VA Facility 2");
    	fac2.setFacilityStation("999");
    	
    	allowedFacilities = new ArrayList<Facility>();
    	allowedFacilities.add(fac1);
    	
    	allFacilities = new ArrayList<Facility>();
    	allFacilities.add(fac1);
    	allFacilities.add(fac2);
    }

	@Override
	public Collection<gov.va.nvap.svc.facility.data.Facility> getAllVistAFacilities() {
		// TODO Auto-generated method stub
		return this.allFacilities;
	}

	@Override
	public gov.va.nvap.svc.facility.data.Facility getFacilityByStationNumber(
			String id) throws EntityDoesNotExistException,
			IllegalArgumentException {
		// TODO Auto-generated method stub
		return fac1;
	}

	@Override
	public gov.va.nvap.svc.facility.data.Facility getVHAUserFacility(
			String vhaUserId) throws EntityDoesNotExistException,
			IllegalArgumentException {
		// TODO Auto-generated method stub
		return fac1;
	}

	@Override
	public Collection<Facility> getAllowedVistAFacilities() {
		// TODO Auto-generated method stub
		return this.allowedFacilities;
	}

	@Override
	public Location getLocationByCode(String locationCode)
			throws EntityDoesNotExistException, IllegalArgumentException {
		// TODO Auto-generated method stub
		return null;
	}
}
