/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.server.test.endpoint.psim;

import gov.va.nvap.server.endpoint.psim.PersonServiceEndpoint;
import gov.va.nvap.server.endpoint.psim.PersonServiceException;

import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.ws.client.core.WebServiceTemplate;

/**
 *
 * @author vhaislegberb
 */
public class PersonServiceEndpointTest {

    private static String GOOD_VPID = "1012593913";
    private static String BAD_VPID = "1012133474";
    private static String INVALID_VPID = "10121334";
    private WebServiceTemplate wsTemplate;

    @Before
    public void beforeTest() {
        wsTemplate = new WebServiceTemplate();
        wsTemplate.setDefaultUri("http://vhaacsapp21.aac.va.gov:7957/psim_webservice/PSIMWebService");
    }
    
    @Test
    public void testDummyTestMethod()
    {
    }

    //@Test
    public void testPersonServiceEndpointSuccess() {
        PersonServiceEndpoint pse = new PersonServiceEndpoint();
        pse.setPsimTemplate(wsTemplate);
        List<String> vpids = pse.getCorrelatedIds(GOOD_VPID);
        Assert.assertTrue(vpids.size() == 1);
        Assert.assertTrue(vpids.get(0).startsWith(GOOD_VPID));
    }

    //@Test(expected = PersonServiceException.class)
    public void testPersonServiceEndpointFail() {
        try {
            PersonServiceEndpoint pse = new PersonServiceEndpoint();
            pse.setPsimTemplate(wsTemplate);
            pse.getCorrelatedIds(BAD_VPID);
        } catch (PersonServiceException pse) {
            System.out.println(pse.getMessage());
            throw pse;
        }
    }
    
    //@Test(expected = IllegalArgumentException.class)
    public void testPersonServiceEndpointInvalidVpid() {
        try {
            PersonServiceEndpoint pse = new PersonServiceEndpoint();
            pse.setPsimTemplate(wsTemplate);
            pse.getCorrelatedIds(INVALID_VPID);
        } catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
            throw iae;
        }
    }
}
