package gov.va.nvap.server.test.endpoint.privacy;

import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.transformer.xml.StringToXML;
import gov.va.nvap.common.transformer.xml.XMLToString;
import gov.va.nvap.common.transformer.xsl.XMLtoXML;
import gov.va.nvap.common.validation.Assert;
import gov.va.nvap.common.xpath.XPathException;
import gov.va.nvap.server.test.common.AbstractTestCase;

import java.io.IOException;

import javax.annotation.Resource;
import javax.xml.bind.JAXBException;

import org.junit.Test;
import org.w3c.dom.Document;

public class TestPatientConsentDirectiveDocumentToData extends AbstractTestCase {

	@Resource(name = "patientConsentDirectiveDocumentToData")
	private XMLtoXML patientConsentDirectiveDocumentToData;

	@Test
	public void testTransformer() throws IOException, TransformerException,
			XPathException, JAXBException {

		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/service/privacy/SampleCDAConsentDirectiveStructuredExcludeOrg.xml");
		final String consentDirectiveData = FileUtil.getResource(resource);
		final Document consentDirectiveDataDoc = new StringToXML()
				.transform(consentDirectiveData);

		final Document doc = this.patientConsentDirectiveDocumentToData
				.transform(consentDirectiveDataDoc);
		System.out.println(new XMLToString(true).transform(doc));

		Assert.assertNotEmpty(doc, "Document cannot be null!");
	}

}
