package gov.va.nvap.server.test.endpoint.privacy;

import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.privacy.ConsentDirectiveAuthorizationRequest;
import gov.va.nvap.privacy.ConsentDirectiveDocumentRetrieveRequest;
import gov.va.nvap.privacy.ConsentDirectiveDocumentType;
import gov.va.nvap.privacy.ConsentDirectiveOptOutReasonType;
import gov.va.nvap.privacy.ConsentDirectiveQueryParamType;
import gov.va.nvap.privacy.ConsentDirectiveQueryRequest;
import gov.va.nvap.privacy.ConsentDirectiveReferenceType;
import gov.va.nvap.privacy.ConsentDirectiveRevocationRequest;
import gov.va.nvap.privacy.ConsentType;
import gov.va.nvap.privacy.OrganizationsQueryRequest;
import gov.va.nvap.privacy.OrganizationsQueryResponse;
import gov.va.nvap.privacy.ServiceConsumer;
import gov.va.nvap.privacy.ServiceConsumerContextType;
import gov.va.nvap.server.test.common.AbstractTestCase;
import gov.va.nvap.service.privacy.ConsentManagementService;
import gov.va.nvap.service.privacy.ConsentManagementServiceException;

import java.io.IOException;

import javax.annotation.Resource;

import org.junit.Test;

public class TestConsentManagementService extends AbstractTestCase {

	@Resource(name = "consentManagementService")
	ConsentManagementService consentManagementService;

	@Test
	public void testAuthorize() throws ConsentManagementServiceException,
			IOException {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/service/privacy/SampleCDAConsentDirectiveStructuredExcludeOrg.xml");

		final ConsentDirectiveAuthorizationRequest request = new ConsentDirectiveAuthorizationRequest();
		request.setDocument(FileUtil.getResource(resource).getBytes());
		request.setServiceConsumerContext(getServiceConsumerContext("      TEST", "983"));
		try {
		this.consentManagementService
				.processConsentDirectiveAuthorization(request);
		} catch (ConsentManagementServiceException ex) {
			// Catch Active Consent Directive Exception
		}
	}

	private ServiceConsumerContextType getServiceConsumerContext(String userId, String userFacilityStationId) {
		ServiceConsumerContextType consumerContext = new ServiceConsumerContextType();
		consumerContext.setFacility(userFacilityStationId);
		consumerContext.setConsentType(ConsentType.NW_HIN_AUTHORIZATION);
		consumerContext.setServiceConsumerType(ServiceConsumer.ADMINISTRATOR_PORTAL);
		consumerContext.setUser(userId);
		return consumerContext;
	}

	private ServiceConsumerContextType getServiceConsumerContextRevocation(String userId, String userFacilityStationId) {
		ServiceConsumerContextType consumerContext = new ServiceConsumerContextType();
		consumerContext.setFacility(userFacilityStationId);
		consumerContext.setConsentType(ConsentType.NW_HIN_REVOCATION);
		consumerContext.setServiceConsumerType(ServiceConsumer.ADMINISTRATOR_PORTAL);
		consumerContext.setUser(userId);
		return consumerContext;
	}


	@Test
	public void testGetAllowedOrganizations()
			throws ConsentManagementServiceException {
		final OrganizationsQueryRequest request = new OrganizationsQueryRequest();
		request.setServiceConsumerContext(getServiceConsumerContext("      TEST", "983"));
		final OrganizationsQueryResponse response = this.consentManagementService
				.getOrganizations(request);
		response.getOrganization();
	}

	@Test
	public void testQueryConsentDirectiveActive()
			throws ConsentManagementServiceException, IOException {

		final ConsentDirectiveQueryRequest request = new ConsentDirectiveQueryRequest();
		request.setPatientId("111111");
		request.setServiceConsumerContext(getServiceConsumerContext("      TEST", "983"));
		request.setQueryParam(ConsentDirectiveQueryParamType.ACTIVE);
		this.consentManagementService.getConsentDirectives(request);
	}

	@Test
	public void testQueryConsentDirectiveAll()
			throws ConsentManagementServiceException, IOException {

		final ConsentDirectiveQueryRequest request = new ConsentDirectiveQueryRequest();
		request.setServiceConsumerContext(getServiceConsumerContext("      TEST", "983"));
		request.setPatientId("111111");
		this.consentManagementService.getConsentDirectives(request);
	}

	@Test
	public void testRetrieveConsentDirective()
			throws ConsentManagementServiceException, IOException {

		final ConsentDirectiveDocumentRetrieveRequest request = new ConsentDirectiveDocumentRetrieveRequest();
		final ConsentDirectiveReferenceType directive = new ConsentDirectiveReferenceType();
		request.setServiceConsumerContext(getServiceConsumerContext("      TEST", "983"));
		directive.setConsentDirId("99999");
		request.setConsentDirectiveReference(directive);

		this.consentManagementService.getConsentDirectiveDocuments(request);
	}

	@Test
	public void testRetrieveConsentDirectiveWithOptIn()
			throws ConsentManagementServiceException, IOException {

		final ConsentDirectiveDocumentRetrieveRequest request = new ConsentDirectiveDocumentRetrieveRequest();
		final ConsentDirectiveReferenceType directive = new ConsentDirectiveReferenceType();
		directive.setConsentDirId("99999");
		request.setServiceConsumerContext(getServiceConsumerContext("      TEST", "983"));
		request.setConsentDirectiveReference(directive);
		request.setDocumentType(ConsentDirectiveDocumentType.AUTHORIZE);
		this.consentManagementService.getConsentDirectiveDocuments(request);
	}

	@Test
	public void testRevoke() throws ConsentManagementServiceException,
			IOException {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/service/privacy/SampleCDAConsentDirectiveStructuredExcludeOrg-Revoke.xml");

		final ConsentDirectiveRevocationRequest request = new ConsentDirectiveRevocationRequest();
		request.setDocument(FileUtil.getResource(resource).getBytes());
		request.setServiceConsumerContext(getServiceConsumerContextRevocation("      TEST", "983"));
		request.setOptoutReason(ConsentDirectiveOptOutReasonType.REVOKED);
		this.consentManagementService
				.processConsentDirectiveRevocation(request);
	}

}
