package gov.va.nvap.server.test.endpoint.privacy;

import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.transformer.xml.StringToXML;
import gov.va.nvap.server.test.common.AbstractTestCase;

import java.io.IOException;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import org.junit.Test;
import org.w3c.dom.Document;

public class TestConsentManagementDirectiveDocument extends AbstractTestCase {

	@Test
	public void testConsentManagementDirectiveDocument() throws IOException,
			TransformerException, JAXBException {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/endpoint/adapter/report/VA_CHDRONE_c62_10292010.xml");
		final String consentManagementDirectiveDocument = FileUtil
				.getResource(resource);
		final Document doc = new StringToXML()
				.transform(consentManagementDirectiveDocument);
		final JAXBContext context = JAXBContext.newInstance("org.hl7.v3");
		final Unmarshaller unmarshaller = context.createUnmarshaller();
		unmarshaller.unmarshal(doc);

		// POCDMT000040ClinicalDocument document =
		// (POCDMT000040ClinicalDocument) unmarshaller
		// .unmarshal(doc);
		// Document xmlDoc = jaxbUtil.marshal(document);
		// System.out.println(new XMLToString().transform(xmlDoc));

	}
}
