package gov.va.nvap.server.test.endpoint.privacy;

import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.transformer.xml.XMLToString;
import gov.va.nvap.privacy.ConsentDirectiveAuthorizationResponse;
import gov.va.nvap.privacy.ConsentDirectiveOptOutReasonType;
import gov.va.nvap.privacy.ConsentDirectiveReferenceType;
import gov.va.nvap.privacy.OrganizationType;
import gov.va.nvap.server.test.common.AbstractTestCase;

import java.util.Date;

import javax.annotation.Resource;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;

import org.junit.Test;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.w3c.dom.Document;

public class TestConsentDirectiveSchema extends AbstractTestCase {

	@Resource(name = "cmsJaxb2Marshaller")
	private Jaxb2Marshaller cmsJaxb2Marshaller;

	@Test
	public void testConsentDirectiveSchema() throws TransformerException {

		final ConsentDirectiveAuthorizationResponse responseType = new ConsentDirectiveAuthorizationResponse();
		final ConsentDirectiveReferenceType reference = new ConsentDirectiveReferenceType();
		reference.setConsentDirId("1111");
		reference.setOptinTS(new Date());
		reference.setExpirationDate(new Date());
		reference.setOptinDate(new Date());
		reference.setOptoutDate(new Date());
		reference.setOptoutTS(new Date());
		reference.setOptoutReason(ConsentDirectiveOptOutReasonType.ENTERED_IN_ERROR);
		reference.setPatientIen("TestIEN");
		final OrganizationType type1 = new OrganizationType();
		type1.setOrgNumber("VA");
		final OrganizationType type2 = new OrganizationType();
		type2.setOrgNumber("200DOD");

		reference.getExcludedOrganizations().add(type1);
		reference.getExcludedOrganizations().add(type2);
		responseType.setConsentDirectiveReference(reference);

		final DOMResult result = new DOMResult();
		this.cmsJaxb2Marshaller.marshal(responseType, result);
		System.out.println(new XMLToString().transform((Document) result
				.getNode()));
		this.cmsJaxb2Marshaller.unmarshal(new DOMSource(result.getNode()));

	}
}
