package gov.va.nvap.server.test.endpoint.pip;

import gov.va.nvap.privacy.ConsentDirectiveDetailedExpirationRequest;
import gov.va.nvap.svc.consentmgmt.PIPInterface;
import gov.va.nvap.svc.consentmgmt.PolicyConstraints;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.Announcement;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementOrg;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentType;
import gov.va.nvap.svc.consentmgmt.stub.data.DetailedConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.ExpiringConsentConfiguration;
import gov.va.nvap.svc.consentmgmt.stub.data.Facility;
import gov.va.nvap.svc.consentmgmt.stub.data.FacilityOptInConsent;
import gov.va.nvap.svc.consentmgmt.stub.data.FunctionalRole;
import gov.va.nvap.svc.consentmgmt.stub.data.Location;
import gov.va.nvap.svc.consentmgmt.stub.data.OptoutReason;
import gov.va.nvap.svc.consentmgmt.stub.data.Organization;
import gov.va.nvap.svc.consentmgmt.stub.data.PatientDocument;
import gov.va.nvap.svc.consentmgmt.stub.data.PatientDocumentType;
import gov.va.nvap.svc.consentmgmt.stub.data.PurposeOfUse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class MockPolicyInformationPoint implements PIPInterface {

    Collection<Facility> facilities;
    Collection<Organization> organizations;
    Collection<Organization> consumerOnlyOrganizations;
    Collection<Organization> nonConsumerOnlyOrganizations;

    public MockPolicyInformationPoint() {
    }

    @Override
    public ConsentDirective getActiveConsentDirective(
        final Collection<String> patientIens, ConsentType consentType) {
        final ConsentDirective consentDirective = new ConsentDirective();
        consentDirective.setConsentDirId(999999L);
        consentDirective.setOptinTS(new Date());
        consentDirective.setExpirationDate(new Date());
        consentDirective.setOptinDate(new Date());
        consentDirective.setOptinConsentType(consentType);
        for (final String ien : patientIens) {
            consentDirective.setPatientIen(ien);
            break;
        }
        return consentDirective;
    }

    @Override
    public Collection<FunctionalRole> getAllowedFunctionalRoles() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public Collection<Organization> getAllowedOrganizations() {
        return this.organizations;
    }

    @Override
    public Boolean getIsOrganizationTrustedSource(String organizationId) {
        return true;
    }

    @Override
    public Collection<PurposeOfUse> getAllowedPurposeOfUse() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public Collection<Facility> getAllowedVistAFacilities() {
        return this.facilities;
    }

    @Override
    public String getAuthorityName(final String oid) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public PatientDocument getConsentDirectiveDocumentByType(
        final ConsentDirective consentDirective,
        final PatientDocumentType patientDocumentType) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public Collection<PatientDocument> getConsentDirectiveDocuments(
        final ConsentDirective consentDirective) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public Collection<ConsentDirective> getConsentHistory(
        final Collection<String> patientIens) {
        String patientIen = null;
        for (final String ien : patientIens) {
            patientIen = ien;
            break;
        }
        final ConsentDirective consentDirective1 = new ConsentDirective();
        consentDirective1.setConsentDirId(999999L);
        consentDirective1.setOptinTS(new Date());
        consentDirective1.setExpirationDate(new Date());
        consentDirective1.setOptinDate(new Date());
        consentDirective1.setPatientIen(patientIen);
        ConsentType consentType = new ConsentType();
        consentType.setName("NwHIN Authorization");
        consentDirective1.setOptinConsentType(consentType);

        final ConsentDirective consentDirective2 = new ConsentDirective();
        consentDirective2.setConsentDirId(999999L);
        consentDirective2.setOptinTS(new Date());
        consentDirective2.setExpirationDate(new Date());
        consentDirective2.setOptinDate(new Date());
        consentDirective2.setPatientIen(patientIen);
        consentDirective2.setOptoutTS(new Date());
        consentDirective2.setOptoutDate(new Date());
        consentDirective2.setOptoutReason(this.getOptoutReasons().iterator()
            .next());
        consentDirective2.setOptinConsentType(consentType);

        consentDirective2.setExcludedOrganizations(this
            .getAllowedOrganizations());

        final Collection<ConsentDirective> directives = new ArrayList<ConsentDirective>();
        directives.add(consentDirective2);
        directives.add(consentDirective1);

        return directives;
    }

    @Override
    public Collection<OptoutReason> getOptoutReasons() {
        final Collection<OptoutReason> reasons = new ArrayList<OptoutReason>();
        reasons.add(new OptoutReason(1L, "Entered in Error"));
        reasons.add(new OptoutReason(2L, "Patient Deceased"));
        reasons.add(new OptoutReason(3L, "Revoked"));
        reasons.add(new OptoutReason(3L, "New Authorization"));
        return reasons;
    }

    @Override
    public Organization getOrganizationById(final Long id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Organization getOrganizationByOid(final String orgOrid) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<PatientDocumentType> getPatientDocumentTypes() {
        final Collection<PatientDocumentType> patientDocumentType = new ArrayList<PatientDocumentType>();
        patientDocumentType.add(new PatientDocumentType(1L, "Authorize"));
        patientDocumentType.add(new PatientDocumentType(2L, "Revoke"));
        return patientDocumentType;
    }

    @Override
    public PolicyConstraints getPolicyConstraints(
        final Collection<String> patientIens, ConsentType consentType) {
        // TODO Auto-generated method stub
        return null;
    }

    public void setFacilities(final Collection<Facility> facilities) {
        this.facilities = facilities;
    }

    public void setOrganizations(final Collection<Organization> organizations) {
        this.organizations = organizations;
    }

    public void setNonConsumerOnlyOrganizations(final Collection<Organization> nonConsumerOnlyOrganizations) {
        this.nonConsumerOnlyOrganizations = nonConsumerOnlyOrganizations;
    }

    public void setConsumerOnlyOrganizations(final Collection<Organization> consumerOnlyOrganizations) {
        this.consumerOnlyOrganizations = consumerOnlyOrganizations;
    }

    @Override
    public void storeConsentDirective(final ConsentDirective consentDirective) {
        // TODO Auto-generated method stub
    }

    @Override
    public Location getLocationByCode(String locationCode) {
        return null;
    }

    @Override
    public void storeOrganization(final Organization organization) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void storePatientDocument(final PatientDocument patientDocument) {
        // TODO Auto-generated method stub
    }

    @Override
    public void updatePatientDocument(PatientDocument patientDocument) {
        // TODO Auto-generated method stub
    }

    public Facility getFacilityByStationId(String id) {
        return null;
    }

    @Override
    public ConsentType getConsentTypeByName(String name) {
        ConsentType type = new ConsentType();
        type.setName("NwHIN Authorization");
        return type;
    }

    @Override
    public Collection<ConsentDirective> getActiveConsentDirectives(
        Collection<String> patientIens) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public PurposeOfUse getPurposeOfUseByValue(String name) {
        if ("TREATMENT".equals(name)) {
            PurposeOfUse pou = new PurposeOfUse();
            pou.setPouValue("TREATMENT");
            return pou;
        } else if ("COVERAGE".equals(name)) {
            PurposeOfUse pou = new PurposeOfUse();
            pou.setPouValue("COVERAGE");
        }
        return null;
    }

    @Override
    public Collection<Organization> getAllowedNonConsumerOnlyOrganizations() {
        // TODO Auto-generated method stub
        return this.nonConsumerOnlyOrganizations;
    }

    @Override
    public Collection<Organization> getAllowedConsumerOnlyOrganizations() {
        // TODO Auto-generated method stub
        return this.consumerOnlyOrganizations;
    }

    @Override
    public Collection<ConsentDirective> getExpiringPatientConsentDirectives(
        Collection<String> patientIens,
        ConsentDirectiveDetailedExpirationRequest consentDirectiveExpirationRequest) {
        // TODO Auto-generated method stub
        // TODO Something a little better then this...
        return new ArrayList<ConsentDirective>();
    }

    @Override
    public ExpiringConsentConfiguration getExpiringConsentConfiguration() {
        return new ExpiringConsentConfiguration();
    }

    @Override
    public void updateExpiringConsentConfiguration(ExpiringConsentConfiguration config) {
    }

    @Override
    public Collection<DetailedConsentDirective> getExpiringPatientDetailedConsentDirectives(ConsentDirectiveDetailedExpirationRequest consentDirectiveExpirationRequest) {
        return null;
    }

    @Override
    public Collection<FacilityOptInConsent> getAuthorizedConsentForSummary() {
        return null;
    }

    @Override
    public Collection<AnnouncementOrg> getAllAnnouncementOrgs() {
        return null;
    }

    @Override
    public Collection<AnnouncementOrg> getAnnouncementOrgsByAnnouncement(Announcement announcement) {
        return null;
    }

    @Override
    public void storeAnnouncementOrg(AnnouncementOrg announceOrg) {
        // TODO Auto-generated method stub
    }

    @Override
    public void updateAnnouncementOrg(AnnouncementOrg announceOrg) {
    }

    @Override
    public Collection<ConsentDirective> getRecentlyExpiredConsent() {
        return new ArrayList<ConsentDirective>();
    }

    @Override
    public ConsentDirective getConsentDirective(Long id) {
        return null;
    }

    @Override
    public Facility getFacilityByName(String facilityName) {
        return null;
    }
}
