package gov.va.nvap.server.test.endpoint.pdq;

import gov.va.nvap.server.test.common.AbstractTestCase;
import gov.va.nvap.service.pdq.PatientMatchQuery;
import gov.va.nvap.service.pdq.PatientMatchResponse;
import gov.va.nvap.service.pdq.PatientProfile;
import gov.va.nvap.service.pdq.PdqException;
import gov.va.nvap.service.pdq.PdqService;

import javax.annotation.Resource;
import javax.xml.bind.JAXBException;

import org.junit.Test;

public class TestSearchPatient extends AbstractTestCase {

	@Resource(name = "pdqService")
	PdqService pdqService;

	@Test
	public void testMpiFailure() throws JAXBException, PdqException {
		final PatientProfile patient = new PatientProfile();
		patient.setFirstName("ERROR");
		patient.setLastName("CHDRZZZTESTPATIENT");
		patient.setSsn("666000001");
		final PatientMatchQuery patientMatchQuery = new PatientMatchQuery();
		patientMatchQuery.setPatientProfile(patient);

		final PatientMatchResponse patientMatchResponse = this.pdqService
				.searchPatient(patientMatchQuery);

		junit.framework.Assert.assertEquals("MVI Unavailable",
				patientMatchResponse.getError().getErrorDescription());
	}

	@Test
	public void testMpiMultipleMatches() throws JAXBException, PdqException {
		final PatientProfile patient = new PatientProfile();
		patient.setFirstName("CHDRTWO");
		patient.setLastName("CHDRZZZTESTPATIENT");
		patient.setSsn("666000002");
		final PatientMatchQuery patientMatchQuery = new PatientMatchQuery();
		patientMatchQuery.setPatientProfile(patient);

		final PatientMatchResponse patientSearchResponse = this.pdqService
				.searchPatient(patientMatchQuery);

		junit.framework.Assert.assertEquals(4, patientSearchResponse
				.getPatients().getPatientProfile().size());
	}

	@Test
	public void testMpiSingleMatch() throws JAXBException, PdqException {
		final PatientProfile patient = new PatientProfile();
		patient.setFirstName("CHDRONE");
		patient.setLastName("CHDRZZZTESTPATIENT");
		patient.setSsn("666000001");
		final PatientMatchQuery patientMatchQuery = new PatientMatchQuery();
		patientMatchQuery.setPatientProfile(patient);

		final PatientMatchResponse patientSearchResponse = this.pdqService
				.searchPatient(patientMatchQuery);

		junit.framework.Assert.assertEquals("CHDRZZZTESTPATIENT",
				patientSearchResponse.getPatients().getPatientProfile().get(0)
						.getLastName());
	}

}
