package gov.va.nvap.server.test.endpoint.pdq;

import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.common.jaxb.JaxbUtil;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.transformer.xml.StringToXML;
import gov.va.nvap.common.transformer.xsl.XMLtoXML;
import gov.va.nvap.common.xpath.XPathException;
import gov.va.nvap.server.test.common.AbstractTestCase;
import gov.va.nvap.service.pdq.PatientMatchResponse;

import java.io.IOException;

import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import javax.xml.xpath.XPathExpressionException;

import junit.framework.Assert;

import org.junit.Test;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

public class TestRSPK22ToPatientMatchResponse extends AbstractTestCase {

	@Resource(name = "pdqJaxbHelper")
	private JaxbUtil jaxbHelper;

	@Resource(name = "rspK22ToPatientMatchResponseTransformer")
	private XMLtoXML rspK22ToPatientMatchResponseTransformer;

	@Test
	public void testRSPK22ToPatientMatchResponseTransformer()
			throws IOException, TransformerException, XPathException,
			XPathExpressionException, JAXBException {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/endpoint/mvi/RSP_K22_MultipleMatches.xml");
		final String rspK22MultipleMatches = FileUtil.getResource(resource);
		final Document rspK22MultipleMatchesDocument = new StringToXML()
				.transform(rspK22MultipleMatches);
		final Document patientMatchResponse = this.rspK22ToPatientMatchResponseTransformer
				.transform(rspK22MultipleMatchesDocument);
		final PatientMatchResponse patientMatchResponseObject = (PatientMatchResponse) this.jaxbHelper
				.unmarshal(patientMatchResponse);
		Assert.assertEquals(patientMatchResponseObject.getPatients()
				.getPatientProfile().size(), 4);
	}

	@Test
	public void testRSPK22ToPatientMatchResponseTransformerFailure()
			throws IOException, TransformerException, DOMException,
			XPathExpressionException, JAXBException {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/endpoint/mvi/RSP_K22_Failure.xml");
		final String rspK22MultipleMatches = FileUtil.getResource(resource);
		final Document rspK22MultipleMatchesDocument = new StringToXML()
				.transform(rspK22MultipleMatches);
		final Document patientMatchResponse = this.rspK22ToPatientMatchResponseTransformer
				.transform(rspK22MultipleMatchesDocument);
		final PatientMatchResponse patientMatchResponseObject = (PatientMatchResponse) this.jaxbHelper
				.unmarshal(patientMatchResponse);
		Assert.assertEquals(patientMatchResponseObject.getError()
				.getErrorDescription(), "MVI Unavailable");
	}

}
