package gov.va.nvap.server.test.endpoint.pdq;

import gov.va.nvap.common.aggregator.Aggregator;
import gov.va.nvap.common.aggregator.AggregatorException;
import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.common.jaxb.JaxbUtil;
import gov.va.nvap.common.transformer.Transformer;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.xpath.XPathException;
import gov.va.nvap.server.test.common.AbstractTestCase;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import javax.xml.xpath.XPathExpressionException;

import org.junit.Test;
import org.w3c.dom.Document;

public class TestRPCResponseToPatientDemograpicsResponse extends
		AbstractTestCase {

	@Resource(name = "pdqJaxbHelper")
	private JaxbUtil jaxbHelper;

	@Resource(name = "rpcResponsesToPatientDemographicsResponse")
	private Transformer<Map<String, Object>, Document> rpcResponsesToPatientDemograpicsResponse;

	@Resource(name = "patientPrimaryViewRpcResponseToPropertyMap")
	Transformer<String, Map<String, String>> patientPrimaryViewRpcResponseToPropertyMap;

	@Resource(name = "patientExtendedViewRpcResponseToPropertyMap")
	Transformer<String, Map<String, String>> patientExtendedViewRpcResponseToPropertyMap;

	@Resource(name = "propertyMapAggregator")
	private Aggregator<Map<String, Object>, Map<String, ?>> propertyMapAggregator;

	@Test
	public void testRpcResponseToPatientDemographicsResponseTransformer()
			throws IOException, TransformerException, XPathException,
			XPathExpressionException, JAXBException, AggregatorException {

		final org.springframework.core.io.Resource resource1 = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/endpoint/vista/mvi/MPI_RETURN_PRIMARY_VIEW_DATA.txt");
		final String mpiPrimaryViewData = FileUtil.getResource(resource1);

		final org.springframework.core.io.Resource resource2 = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/endpoint/vista/mvi/MPI RETURN CORRELATION DATA SPLIT.txt");
		final String mpiExtendedViewData = FileUtil.getResource(resource2);

		final Map<String, String> patientPrimaryViewPropertyMap = this.patientPrimaryViewRpcResponseToPropertyMap
				.transform(mpiPrimaryViewData);
		final Map<String, String> patientExtendedViewPropertyMap = this.patientExtendedViewRpcResponseToPropertyMap
				.transform(mpiExtendedViewData);
		final Map<String, Set<String>> map = new HashMap<String, Set<String>>();
		final Set<String> sites = new HashSet<String>();
		sites.add("552");
		sites.add("983");
		map.put("sites", sites);
		// Aggregate the primary, extended and sites maps
		final Map<String, Object> patientViewPropertyMap = this.propertyMapAggregator
				.aggregate(patientExtendedViewPropertyMap,
						patientPrimaryViewPropertyMap, map);

		final Document doc = this.rpcResponsesToPatientDemograpicsResponse
				.transform(patientViewPropertyMap);

		this.jaxbHelper.unmarshal(doc);
	}
}
