package gov.va.nvap.server.test.endpoint.pdq;

import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.common.transformer.Transformer;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.server.test.common.AbstractTestCase;

import java.io.IOException;
import java.util.Map;

import javax.annotation.Resource;

import junit.framework.Assert;

import org.junit.Test;

public class TestPrimaryViewDataExpressions extends AbstractTestCase {

	@Resource(name = "patientPrimaryViewRpcResponseToPropertyMap")
	Transformer<String, Map<String, String>> patientPrimaryViewRpcResponseToPropertyMap;

	@Test
	public void testPatientExtendedViewSplitter() throws IOException,
			TransformerException {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/endpoint/vista/mvi/MPI_RETURN_PRIMARY_VIEW_DATA.txt");
		final String mpiPrimaryViewData = FileUtil.getResource(resource);

		final Map<String, String> propertyMap = this.patientPrimaryViewRpcResponseToPropertyMap
				.transform(mpiPrimaryViewData);
		Assert.assertEquals("CHDRONE", propertyMap.get("firstName"));
	}

}
