package gov.va.nvap.server.test.endpoint.pdq;

import gov.va.nvap.server.test.common.AbstractTestCase;
import gov.va.nvap.service.pdq.PatientCorrelationsQuery;
import gov.va.nvap.service.pdq.PatientCorrelationsResponse;
import gov.va.nvap.service.pdq.PdqException;
import gov.va.nvap.service.pdq.PdqService;

import javax.annotation.Resource;
import javax.xml.bind.JAXBException;

import junit.framework.Assert;

import org.junit.Test;

public class TestPatientSiteListQuery extends AbstractTestCase {

	@Resource(name = "pdqService")
	PdqService pdqService;

	@Test
	public void testPatientSiteListQuery() throws JAXBException, PdqException {
		final PatientCorrelationsQuery patientCorrelationsQuery = new PatientCorrelationsQuery();
		patientCorrelationsQuery.setPatientId("1012581676V377802");
		final PatientCorrelationsResponse patientCorrelationsResponse = this.pdqService
				.getCorrelatedFacilities(patientCorrelationsQuery);
		Assert.assertTrue(patientCorrelationsResponse.getFacilities().size() > 0);
	}
}
