package gov.va.nvap.server.test.endpoint.pdq;

import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.transformer.xml.StringToXML;
import gov.va.nvap.common.transformer.xsl.XMLtoXML;
import gov.va.nvap.common.xpath.XPathException;
import gov.va.nvap.common.xpath.XPathUtil;
import gov.va.nvap.server.test.common.AbstractTestCase;

import java.io.IOException;

import javax.annotation.Resource;

import junit.framework.Assert;

import org.junit.Test;
import org.w3c.dom.Document;

public class TestPatientMatchQueryToQBPQ22Transformation extends
		AbstractTestCase {

	@Resource(name = "patientMatchQueryToQBPQ22Transformer")
	private XMLtoXML patientMatchQueryToQBPQ22Transformer;

	@Test
	public void testPatientSearchRequestToQBPQ22Transformer()
			throws IOException, TransformerException, XPathException {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/endpoint/pdq/PatientMatchQuery.xml");
		final String patientSearchRequestString = FileUtil
				.getResource(resource);
		final Document patientSearchRequestDocument = new StringToXML()
				.transform(patientSearchRequestString);
		final Document qbpQ22 = this.patientMatchQueryToQBPQ22Transformer
				.transform(patientSearchRequestDocument);
		Assert.assertEquals(XPathUtil.getFieldByPath(qbpQ22,
				"//QBP_Q22/QPD/QPD.3[1]/UNKNOWN.2"), "CHDRZZZTESTPATIENT");
		Assert.assertEquals(XPathUtil.getFieldByPath(qbpQ22,
				"//QBP_Q22/QPD/QPD.3[1]/UNKNOWN.3"), "CHDRONE");
		Assert.assertEquals(XPathUtil.getFieldByPath(qbpQ22,
				"//QBP_Q22/QPD/QPD.3[5]/UNKNOWN.2"), "666000001");
	}
}
