package gov.va.nvap.server.test.endpoint.pdq;

import gov.va.nvap.common.jaxb.JaxbUtil;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.server.test.common.AbstractTestCase;
import gov.va.nvap.service.pdq.PatientDemographics;
import gov.va.nvap.service.pdq.PatientDemographicsResponse;
import gov.va.nvap.service.pdq.PatientMatchQuery;
import gov.va.nvap.service.pdq.PatientMatchResponse;
import gov.va.nvap.service.pdq.PatientProfile;
import gov.va.nvap.service.pdq.PatientMatchResponse.Patients;

import java.util.Date;

import javax.annotation.Resource;
import javax.xml.bind.JAXBException;

import junit.framework.Assert;

import org.junit.Test;
import org.w3c.dom.Document;

public class TestPatientDemographicsSchema extends AbstractTestCase {

	@Resource(name = "pdqJaxbHelper")
	private JaxbUtil jaxbHelper;

	@Test
	public void testPatientDemographicsResponse() throws JAXBException,
			TransformerException {

		final PatientDemographics patientDemographics = new PatientDemographics();
		patientDemographics.setFirstName("CHDRONE");
		patientDemographics.setLastName("CHDRZZZTESTPATIENT");
		patientDemographics.setSsn("66600001");
		patientDemographics.setDob(new Date());
		patientDemographics.setMiddleName("C");
		patientDemographics.setGender("F");

		final PatientDemographicsResponse response = new PatientDemographicsResponse();
		response.setPatientDemographics(patientDemographics);

		final Document doc = this.jaxbHelper.marshal(response);

		final PatientDemographicsResponse patientDemographicsResponseUmarshalled = (PatientDemographicsResponse) this.jaxbHelper
				.unmarshal(doc);
		Assert.assertEquals("CHDRONE", patientDemographicsResponseUmarshalled
				.getPatientDemographics().getFirstName());
	}

	@Test
	public void testPatientMatchResponse() throws JAXBException,
			TransformerException {
		final PatientProfile patientA = new PatientProfile();
		patientA.setFirstName("CHDRONE");
		patientA.setLastName("CHDRZZZTESTPATIENT");
		patientA.setSsn("666000001");
		patientA.setDob(new Date(System.currentTimeMillis()));
		patientA.setMiddleInitial("C");
		patientA.setGender("F");

		final PatientProfile patientB = new PatientProfile();
		patientB.setFirstName("CHDRTWO");
		patientB.setLastName("CHDRZZZTESTPATIENT");
		patientB.setSsn("666000002");

		final PatientMatchResponse patientMatchResponse = new PatientMatchResponse();
		final Patients patients = new Patients();
		patients.getPatientProfile().add(patientA);
		patients.getPatientProfile().add(patientB);
		patientMatchResponse.setPatients(patients);

		final Document doc = this.jaxbHelper.marshal(patientMatchResponse);

		final PatientMatchResponse patientMatchResponseUnMarshalled = (PatientMatchResponse) this.jaxbHelper
				.unmarshal(doc);
		Assert.assertEquals(patientMatchResponseUnMarshalled.getPatients()
				.getPatientProfile().get(0).getSsn(), patientA.getSsn());
	}

	@Test
	public void testPatientSearchRequest() throws JAXBException,
			TransformerException {
		final PatientProfile patient = new PatientProfile();
		patient.setFirstName("CHDRONE");
		patient.setLastName("CHDRZZZTESTPATIENT");
		patient.setSsn("666000001");
		final PatientMatchQuery patientMatchRequest = new PatientMatchQuery();
		patientMatchRequest.setPatientProfile(patient);

		final Document doc = this.jaxbHelper.marshal(patientMatchRequest);
		final PatientMatchQuery patientMatchRequestUnMarshalled = (PatientMatchQuery) this.jaxbHelper
				.unmarshal(doc);
		Assert.assertEquals(patientMatchRequestUnMarshalled.getPatientProfile()
				.getSsn(), patient.getSsn());
	}
}
