package gov.va.nvap.server.test.endpoint.pdq;

import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.common.filter.FilterException;
import gov.va.nvap.common.splitter.Splitter;
import gov.va.nvap.common.splitter.SplitterException;
import gov.va.nvap.common.transformer.Transformer;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.server.service.pdq.filter.MostRecentDateFilter;
import gov.va.nvap.server.test.common.AbstractTestCase;

import java.io.IOException;
import java.util.Map;

import javax.annotation.Resource;

import junit.framework.Assert;

import org.junit.Test;

public class TestMostRecentDateFilter extends AbstractTestCase {

	@Resource(name = "rpcExtendedResponseSplitter")
	private Splitter<String, Map<String, String>> rpcExtendedResponseSplitter;

	@Resource(name = "rpcResponsesToPropertyMapRecordTwoPass")
	private Transformer<Map<String, String>, Map<String, Map<String, Object>>> rpcResponsesToPropertyMapRecordTwoPass;

	@Resource(name = "rpcResponsesRecentDateFilter")
	private MostRecentDateFilter rpcResponsesRecentDateFilter;

	@Test
	public void testMostRecentDateFilter() throws IOException,
			TransformerException, FilterException, SplitterException {

		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/endpoint/vista/mvi/MPI RETURN CORRELATION DATA.txt");
		final String rpcResponses = FileUtil.getResource(resource);

		final Map<String, String> splitRpcResponses = this.rpcExtendedResponseSplitter
				.split(rpcResponses);
		final Map<String, Map<String, Object>> rpcResponsesMapRecord = this.rpcResponsesToPropertyMapRecordTwoPass
				.transform(splitRpcResponses);

		final String response = this.rpcResponsesRecentDateFilter
				.filter(rpcResponsesMapRecord);
		Assert.assertNotNull(response);
	}
}
