package gov.va.nvap.server.test.endpoint.mvi;

import gov.va.nvap.common.jaxb.JaxbUtil;
import gov.va.nvap.common.transceiver.client.Transceiver;
import gov.va.nvap.common.transformer.Transformer;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.transformer.hl7.ER7ToXML;
import gov.va.nvap.common.transformer.xsl.XMLtoXML;
import gov.va.nvap.common.xpath.XPathException;
import gov.va.nvap.common.xpath.XPathUtil;
import gov.va.nvap.server.test.common.AbstractTestCase;
import gov.va.nvap.service.pdq.PatientMatchQuery;
import gov.va.nvap.service.pdq.PatientProfile;

import java.io.IOException;

import javax.annotation.Resource;
import javax.xml.bind.JAXBException;

import junit.framework.Assert;

import org.junit.Test;
import org.w3c.dom.Document;

public class TestSocketTransceiver extends AbstractTestCase {

	@Resource(name = "pdqJaxbHelper")
	private JaxbUtil jaxbHelper;

	@Resource(name = "patientMatchQueryToQBPQ22Transformer")
	private XMLtoXML patientMatchQueryToQBPQ22Transformer;

	@Resource(name = "mpiSocketTransceiver")
	Transceiver<String> socketTransceiver;

	@Resource(name = "xmlToEr7Transformer")
	Transformer<Document, String> xmlToEr7Transformer;

	@Test
	public void testMPIQBPQ22MultipleMatches() throws IOException,
			TransformerException, JAXBException, XPathException {

		final PatientProfile patient = new PatientProfile();
		patient.setFirstName("CHDRTWO");
		patient.setLastName("CHDRZZZTESTPATIENT");
		patient.setSsn("666000002");
		final PatientMatchQuery patientMatchQuery = new PatientMatchQuery();
		patientMatchQuery.setPatientProfile(patient);

		final Document patientMatchQueryDocument = this.jaxbHelper
				.marshal(patientMatchQuery);
		final Document qbpQ22Document = this.patientMatchQueryToQBPQ22Transformer
				.transform(patientMatchQueryDocument);
		final String qbpQ222ER7 = this.xmlToEr7Transformer
				.transform(qbpQ22Document);
		final String rspK22Response = this.socketTransceiver
				.transceive(qbpQ222ER7);
		final Document rspK22ResponseDocument = new ER7ToXML()
				.transform(rspK22Response);
		Assert.assertEquals(
				XPathUtil.getFieldByPath(rspK22ResponseDocument, "//QAK.4"),
				"4");
	}

	@Test
	public void testMPIQBPQ22SingleMatch() throws IOException,
			TransformerException, JAXBException, XPathException {

		final PatientProfile patient = new PatientProfile();
		patient.setFirstName("CHDRONE");
		patient.setLastName("CHDRZZZTESTPATIENT");
		patient.setSsn("666000001");
		final PatientMatchQuery patientMatchQuery = new PatientMatchQuery();
		patientMatchQuery.setPatientProfile(patient);

		final Document patientMatchQueryDocument = this.jaxbHelper
				.marshal(patientMatchQuery);
		final Document qbpQ22Document = this.patientMatchQueryToQBPQ22Transformer
				.transform(patientMatchQueryDocument);
		final String qbpQ222ER7 = this.xmlToEr7Transformer
				.transform(qbpQ22Document);
		final String rspK22Response = this.socketTransceiver
				.transceive(qbpQ222ER7);
		final Document rspK22ResponseDocument = new ER7ToXML()
				.transform(rspK22Response);
		Assert.assertEquals(
				XPathUtil.getFieldByPath(rspK22ResponseDocument, "//QAK.4"),
				"1");
	}
}
