package gov.va.nvap.server.test.endpoint.mvi;

import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.common.transformer.Transformer;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.xpath.XPathException;
import gov.va.nvap.common.xpath.XPathUtil;
import gov.va.nvap.server.test.common.AbstractTestCase;

import java.io.IOException;

import javax.annotation.Resource;

import junit.framework.Assert;

import org.junit.Test;
import org.w3c.dom.Document;

public class TestRSPK22ER7ToXML extends AbstractTestCase {

	@Resource(name = "er7ToXmlTransformer")
	Transformer<String, Document> er7ToXmlTransformer;

	@Test
	public void testQBPQ22XMLToER7Failure() throws IOException,
			TransformerException, XPathException {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/endpoint/mvi/RSP_K22_Failure.er7");
		final String rspK22FailureER7 = FileUtil.getResource(resource);
		final Document document = this.er7ToXmlTransformer
				.transform(rspK22FailureER7);
		Assert.assertEquals(XPathUtil.getFieldByPath(document, "//MSA.3"),
				"MVI Unavailable");
	}

	@Test
	public void testQBPQ22XMLToER7MultipleMatches() throws IOException,
			TransformerException, XPathException {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/endpoint/mvi/RSP_K22_MultipleMatches.er7");
		final String rspK22MulitpleMatchesER7 = FileUtil.getResource(resource);
		final Document document = this.er7ToXmlTransformer
				.transform(rspK22MulitpleMatchesER7);
		Assert.assertEquals(XPathUtil.getFieldByPath(document, "//QAK.4"), "4");
	}

	@Test
	public void testQBPQ22XMLToER7NoMatches() throws IOException,
			TransformerException, XPathException {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/endpoint/mvi/RSP_K22_NoMatches.er7");
		final String rspK22NoMatchesER7 = FileUtil.getResource(resource);
		final Document document = this.er7ToXmlTransformer
				.transform(rspK22NoMatchesER7);
		Assert.assertEquals(XPathUtil.getFieldByPath(document, "//QAK.4"), "0");
	}

}
