package gov.va.nvap.server.test.endpoint.mvi;

import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.common.transformer.Transformer;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.transformer.xml.StringToXML;
import gov.va.nvap.common.xpath.XPathException;
import gov.va.nvap.common.xpath.XPathUtil;
import gov.va.nvap.server.test.common.AbstractTestCase;

import java.io.IOException;

import javax.annotation.Resource;

import junit.framework.Assert;

import org.junit.Test;
import org.w3c.dom.Document;

public class TestQBPQ22XMLToER7 extends AbstractTestCase {

	@Resource(name = "er7ToXmlTransformer")
	Transformer<String, Document> er7ToXmlTransformer;

	@Resource(name = "xmlToEr7Transformer")
	Transformer<Document, String> xmlToEr7Transformer;

	@Test
	public void testQBPQ22XMLToER7() throws IOException, TransformerException,
			XPathException {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/endpoint/mvi/QBP_Q22.xml");
		final String patientSearchRequestString = FileUtil
				.getResource(resource);
		final Document qbpQ22Document = new StringToXML()
				.transform(patientSearchRequestString);
		final String qbpQ222ER7 = this.xmlToEr7Transformer
				.transform(qbpQ22Document);
		final Document qbpQ22DocumentTransformed = this.er7ToXmlTransformer
				.transform(qbpQ222ER7);
		Assert.assertEquals("CHDRZZZTESTPATIENT", XPathUtil.getFieldByPath(
				qbpQ22DocumentTransformed, "//QPD/QPD.3[1]/UNKNOWN.2"));
	}
}
