package gov.va.nvap.server.test.endpoint.mvi;

import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.common.jaxb.JaxbUtil;
import gov.va.nvap.common.transformer.Transformer;
import gov.va.nvap.common.transformer.hl7.ER7ToXML;
import gov.va.nvap.common.transformer.xml.XMLToString;
import gov.va.nvap.server.test.common.AbstractTestCase;
import gov.va.nvap.service.pdq.RemovePatientCorrelationRequest;

import javax.annotation.Resource;

import org.junit.Test;
import org.w3c.dom.Document;

public class TestADT37Message extends AbstractTestCase {

	@Resource(name = "removePatientCorrelationRequestToADTA37")
	Transformer<Document, Document> removePatientCorrelationRequestToADTA37;

	@Resource(name = "pdqJaxbHelper")
	private JaxbUtil jaxbHelper;

	@Resource(name = "xmlToEr7Transformer")
	private Transformer<Document, String> xmlToEr7Transformer;

	public void testADTA37ER7ToXML() throws Exception {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/endpoint/vista/mvi/ADT_A37_Populated.er7");
		final String adtA37 = FileUtil.getResource(resource).trim();
		new ER7ToXML().transform(adtA37);
	}

	@Test
	public void testADTA37ER7ToXML2() throws Exception {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/server/test/endpoint/vista/mvi/ADT_A37_Populated_OID.er7");
		final String adtA37 = FileUtil.getResource(resource).trim();
		final Document doc = new ER7ToXML().transform(adtA37);
		System.out.println(new XMLToString().transform(doc));
	}

	@Test
	public void testADTA37Message() throws Exception {

		final RemovePatientCorrelationRequest request = new RemovePatientCorrelationRequest();
		request.setCorrelatedAssigningAuthorityName("CORRELATEDAA_NAME");
		request.setCorrelatedAssigningAuthorityOid("CORRELATED_ASSIGNING_AUTHORITY_NUMBER");
		request.setCorrelatedPatientId("CORRELATED_PATIENT_ID");
		request.setPatientId("PATIENT_ID");
		request.setPatientFirstName("PATIENT_FIRSTNAME");
		request.setPatientLastName("PATIENT_LASTNAME");
		request.setPatientMiddleName("PATIENT_MIDDLENAME");
		final Document doc = this.jaxbHelper.marshal(request);
		final Document adtA37 = this.removePatientCorrelationRequestToADTA37
				.transform(doc);

		final String er7 = this.xmlToEr7Transformer.transform(adtA37);

		System.out.println(er7);

	}

}
