package gov.va.nvap.server.test.endpoint.mvi;

import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.common.transceiver.client.Transceiver;

import java.io.IOException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class MockSocketTransceiver implements Transceiver<String> {

	@Autowired
	ApplicationContext applicationContext;

	@Override
	public String transceive(final String payload) {
		try {
			if (payload.contains("QBP~Q22") && payload.contains("CHDRONE")) {
				final org.springframework.core.io.Resource resource = this.applicationContext
						.getResource("classpath:gov/va/nvap/mock/endpoint/mvi/RSP_K22_SingleMatch.er7");
				final String rspK22ER7 = FileUtil.getResource(resource);
				return rspK22ER7;
			}
			if (payload.contains("QBP~Q22") && payload.contains("MPIPATIENT")
					&& payload.contains("ONE")) {
				final org.springframework.core.io.Resource resource = this.applicationContext
						.getResource("classpath:gov/va/nvap/mock/endpoint/mvi/RSP_K22_MultipleMatches.er7");
				final String rspK22ER7 = FileUtil.getResource(resource);
				return rspK22ER7;
			} else if (payload.contains("QBP~Q22")
					&& payload.contains("CHDRTWO")) {
				final org.springframework.core.io.Resource resource = this.applicationContext
						.getResource("classpath:gov/va/nvap/mock/endpoint/mvi/RSP_K22_MultipleMatches.er7");
				final String rspK22ER7 = FileUtil.getResource(resource);
				return rspK22ER7;
			} else if (payload.contains("QBP~Q22") && payload.contains("ERROR")) {
				final org.springframework.core.io.Resource resource = this.applicationContext
						.getResource("classpath:gov/va/nvap/mock/endpoint/mvi/RSP_K22_Failure.er7");
				final String rspK22ER7 = FileUtil.getResource(resource);
				return rspK22ER7;
			} else {
				final org.springframework.core.io.Resource resource = this.applicationContext
						.getResource("classpath:gov/va/nvap/mock/endpoint/mvi/RSP_K22_NoMatches.er7");
				final String rspK22ER7 = FileUtil.getResource(resource);
				return rspK22ER7;
			}
		} catch (final IOException ex) {
			throw new RuntimeException(ex);
		}
	}

}
