package gov.va.nvap.server.test.endpoint.esr;

import gov.va.med.esr.webservices.jaxws.schemas.DemographicInfo;
import gov.va.med.esr.webservices.jaxws.schemas.EeSummary;
import gov.va.med.esr.webservices.jaxws.schemas.GetEESummaryRequest;
import gov.va.med.esr.webservices.jaxws.schemas.GetEESummaryResponse;
import gov.va.med.esr.webservices.jaxws.schemas.ObjectFactory;
import gov.va.nvap.service.esr.EnrollmentService;

public class MockESRServiceEndpoint implements EnrollmentService {

	@Override
	public GetEESummaryResponse getEESummaryRequest(GetEESummaryRequest request) {
		ObjectFactory objFactory = new ObjectFactory();
		GetEESummaryResponse response = objFactory.createGetEESummaryResponse();
		EeSummary eeSummary = objFactory.createEeSummary();
		response.setSummary(eeSummary);
		DemographicInfo demographicInfo = objFactory.createDemographicInfo();
		eeSummary.setDemographics(demographicInfo);
		System.out.println("MOCK");
		demographicInfo.setPreferredFacility("998 - VA Facility 1");
		return response;
	}

}
