/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.server.test.endpoint.adapter;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

public class Document implements Serializable {
	/**
	 *
	 */
	private static final long serialVersionUID = 3536047695910192199L;
	@Id
	@Basic(optional = false)
	@Column(name = "DOCUMENT_ID")
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "documentIdGenerator")
	private Long documentId;
	@Basic(optional = true)
	@Column(name = "DOCUMENT_UNIQUE_ID")
	private String documentUniqueId;
	@Basic(optional = true)
	@Column(name = "CLASS_CODE")
	private String classCode;
	@Basic(optional = true)
	@Column(name = "CLASS_CODE_SCHEME")
	private String classCodeScheme;
	@Basic(optional = true)
	@Column(name = "CLASS_CODE_DISPLAY_NAME")
	private String classCodeDisplayName;
	@Basic(optional = true)
	@Column(name = "PATIENT_ID")
	private String patientId;
	@Basic(optional = true)
	@Column(name = "TITLE")
	private String title;
	@Basic(optional = true)
	@Column(name = "CREATION_TIME")
	@Temporal(TemporalType.TIMESTAMP)
	private Date creationTime;
	@Basic(optional = true)
	@Column(name = "BEGIN_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date beginDate;
	@Basic(optional = true)
	@Column(name = "END_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date endDate;
	@Basic(optional = true)
	@Column(name = "MIME_TYPE")
	private String mimeType;
	@Basic(optional = true, fetch = FetchType.EAGER)
	@Lob
	@Column(name = "RAW_DATA")
	private byte[] rawData;
	@Basic(optional = true)
	@Column(name = "RAW_DATA_SIZE")
	private Integer size;
	@Basic(optional = true)
	@Column(name = "RAW_DATA_HASH")
	private String hash;
	@Basic(optional = true)
	@Column(name = "LAST_ACCESSED_TIME")
	@Temporal(TemporalType.TIMESTAMP)
	private Date lastAccessedTime;

	public Document() {
	}

	@Override
	public boolean equals(final Object obj) {
		if (!(obj instanceof Document)) {
			return false;
		}
		final Document doc = (Document) obj;
		if ((this != doc)
				&& ((this.documentId == null) || (doc.documentId == null) || !this.documentId
						.equals(doc.documentId))) {
			return false;
		}
		return true;
	}

	public Date getBeginDate() {
		return this.beginDate;
	}

	public String getClassCode() {
		return this.classCode;
	}

	public String getClassCodeDisplayName() {
		return this.classCodeDisplayName;
	}

	public String getClassCodeScheme() {
		return this.classCodeScheme;
	}

	public Date getCreationTime() {
		return this.creationTime;
	}

	public Long getDocumentId() {
		return this.documentId;
	}

	public String getDocumentUniqueId() {
		return this.documentUniqueId;
	}

	public Date getEndDate() {
		return this.endDate;
	}

	public String getHash() {
		return this.hash;
	}

	public Date getLastAccessedTime() {
		return this.lastAccessedTime;
	}

	public String getMimeType() {
		return this.mimeType;
	}

	public String getPatientId() {
		return this.patientId;
	}

	public byte[] getRawData() {
		return this.rawData;
	}

	public Integer getSize() {
		return this.size;
	}

	public String getTitle() {
		return this.title;
	}

	@Override
	public int hashCode() {
		int ret = 0;
		ret += (this.documentId != null ? this.documentId.hashCode() : 0);
		return ret;
	}

	public void setBeginDate(final Date beginDate) {
		this.beginDate = beginDate;
	}

	public void setClassCode(final String classCode) {
		this.classCode = classCode;
	}

	public void setClassCodeDisplayName(final String classCodeDisplayName) {
		this.classCodeDisplayName = classCodeDisplayName;
	}

	public void setClassCodeScheme(final String classCodeScheme) {
		this.classCodeScheme = classCodeScheme;
	}

	public void setCreationTime(final Date creationTime) {
		this.creationTime = creationTime;
	}

	public void setDocumentId(final Long documentId) {
		this.documentId = documentId;
	}

	public void setDocumentUniqueId(final String documentUniqueId) {
		this.documentUniqueId = documentUniqueId;
	}

	public void setEndDate(final Date endDate) {
		this.endDate = endDate;
	}

	public void setHash(final String hash) {
		this.hash = hash;
	}

	public void setLastAccessedTime(final Date lastAccessedTime) {
		this.lastAccessedTime = lastAccessedTime;
	}

	public void setMimeType(final String mimeType) {
		this.mimeType = mimeType;
	}

	public void setPatientId(final String patientId) {
		this.patientId = patientId;
	}

	public void setRawData(final byte[] rawData) {
		this.rawData = rawData;
	}

	public void setSize(final Integer size) {
		this.size = size;
	}

	public void setTitle(final String title) {
		this.title = title;
	}
}
