package gov.va.nvap.server.test.common;

import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = {
		"classpath:gov/va/nvap/server/server-common.xml",
		"classpath:gov/va/nvap/server/endpoint/pdq/pdq-endpoint.xml",
		"classpath:gov/va/nvap/server/endpoint/pip/pip-endpoint.xml",
		"classpath:gov/va/nvap/server/endpoint/mvi/mvi-endpoint.xml",
		"classpath:gov/va/nvap/server/endpoint/vista/vista-endpoint.xml",
		"classpath:gov/va/nvap/server/endpoint/adapter/audit/audit-endpoint.xml",
		"classpath:gov/va/nvap/server/endpoint/adapter/announce/announce-endpoint.xml",
		"classpath:gov/va/nvap/server/endpoint/adapter/doc/adapterDocQuery-endpoint.xml",
		"classpath:gov/va/nvap/server/endpoint/adapter/doc/adapterDocRetrieve-endpoint.xml",
		"classpath:gov/va/nvap/server/service/privacy/privacy-service.xml",
		"classpath:gov/va/nvap/server/test/endpoint/mvi/mvi-test-endpoint.xml",
		"classpath:gov/va/nvap/server/test/endpoint/esr/esr-test-endpoint.xml",
		"classpath:gov/va/nvap/server/test/endpoint/adapter/doc/adapterDocQueryRetrieve-test-endpoint.xml",
		"classpath:gov/va/nvap/server/test/endpoint/adapter/audit/adapterAudit-test-endpoint.xml",
		"classpath:gov/va/nvap/server/test/endpoint/adapter/announce/announce-test-endpoint.xml",
		"classpath:gov/va/nvap/server/test/endpoint/vista/vista-test-endpoint.xml",
		"classpath:gov/va/nvap/server/test/service/audit/audit-test-endpoint.xml",
		"classpath:gov/va/nvap/server/test/endpoint/pip/pip-test-endpoint.xml",
		"classpath:gov/va/nvap/server/test/service/facility/fac-svc-test-endpoint.xml",
                "classpath:gov/va/nvap/server/test/endpoint/psim/psim-test-endpoint.xml",
                "classpath:gov/va/nvap/server/test/endpoint/announce/announce-test-endpoint.xml",
		"classpath:gov/va/nvap/server/test/common/test-common.xml" })
@TestExecutionListeners(value = {
		DependencyInjectionTestExecutionListener.class,
		DirtiesContextTestExecutionListener.class })
public abstract class AbstractTestCase {

	@Autowired
	protected ApplicationContext applicationContext;

}
