package gov.va.nvap.server.endpoint.permission.sls;

import gov.va.nvap.svc.consenteval.common.XACMLContextConstants;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/**
 * Integration test for the SLSClient.
 * To make this run, copy
 * nvap-server/src/main/resources/gov/va/nvap/server/service/permission/sls/simulator/slsSimulator.properties
 * to the config subdirectory of the deployed domain, then start the domain with VAP deployed.
 * 
 * The Spring config loads classpath:server.properties; see the sls.serviceLocation
 * property in there. You may need to adjust the port number depending on which
 * port your app server is running on.
 * @author cbarber
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = {"classpath:gov/va/nvap/server/test/endpoint/permission/sls/sls-endpoint.xml"})
public class SLSClientIT
{
    private static final String SAMPLE_HEALTH_SUMMARY = "/gov/va/nvap/server/test/endpoint/permission/sls/sample_C-CDA_CCD.xml";

    @Autowired
    private SLSClient slsClient;
    
    public SLSClientIT()
    {
    }
    
    @BeforeClass
    public static void setUpClass()
    {
    }
    
    @AfterClass
    public static void tearDownClass()
    {
    }
    
    @Before
    public void setUp()
    {
    }
    
    @After
    public void tearDown()
    {
    }

    /**
     * Test of sendPatientCategory method, of class SLSClient.
     */
    @Test
    public void testEvalConfidentialityCode() throws Exception
    {
        InputStream testInput = getClass().getResourceAsStream(SAMPLE_HEALTH_SUMMARY);
        ByteArrayOutputStream tempBytes = new ByteArrayOutputStream();
        IOUtils.copy(testInput, tempBytes);
        String expResult = XACMLContextConstants.RESOURCE_CONF_CODE_VAL_RESTRICTED;
        String result = slsClient.evalConfidentialityCode(tempBytes.toByteArray());
        assertEquals(expResult, result);
    }
   
}
