<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:util="vap://gov.va.nvap.common.xsl.util"
	xmlns:consentManagement="http://gov/va/nvap/service/privacy"
	xmlns:t="urn:hl7-org:v3" exclude-result-prefixes="util consentManagement t">

	<!-- Process the common templates -->
	<xsl:import href="/gov/va/nvap/common/xsl/Common.xsl" />

	<xsl:template
		match="//*[local-name()='ClinicalDocument' and namespace-uri()='urn:hl7-org:v3']">
		<ConsentDirectiveRevocationResponse
			xmlns="urn:gov:va:nvap:privacy">
			<consentDirectiveReference>
				<consentDirId><xsl:value-of select="t:id/@extension" /></consentDirId>
				<patientIen>
					<xsl:value-of select="t:recordTarget/t:patientRole/t:id[@root='2.16.840.1.113883.4.349']/@extension" />
				</patientIen>
				<xsl:if test="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:statusCode/@code='aborted'">
					<optoutDate>
						<xsl:value-of
							select="util:getDateFromHL7DateTSString(t:documentationOf/t:serviceEvent/t:effectiveTime/t:high/@value)" />
					</optoutDate>
					<optoutTS>
						<xsl:value-of
							select="util:getDateFromHL7DateTSString(t:effectiveTime/@value)" />
					</optoutTS>
				</xsl:if>
				<xsl:for-each
					select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:participant">
					<excludedOrganizations>
						<orgOid>
							<xsl:value-of select="t:participantRole/t:id/@root" />
						</orgOid>
					</excludedOrganizations>
				</xsl:for-each>
			</consentDirectiveReference>
		</ConsentDirectiveRevocationResponse>
	</xsl:template>
</xsl:stylesheet>
