<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:util="vap://gov.va.nvap.common.xsl.util"
	xmlns:patientDemograpicsResponse="http://gov/va/nvap/service/pdq"
	exclude-result-prefixes="util patientDemograpicsResponse">

	<!-- Process the common templates -->
	<xsl:import href="/gov/va/nvap/common/xsl/Common.xsl" />


	<xsl:param name="icn" />
	<xsl:param name="lastName" />
	<xsl:param name="firstName" />
	<xsl:param name="middleName" />
	<xsl:param name="prefix" />
	<xsl:param name="suffix" />
	<xsl:param name="mothersMaidenName" />
	<xsl:param name="dob" />
	<xsl:param name="placeOfBirthCity" />
	<xsl:param name="placeOfBirthState" />
	<xsl:param name="placeOfBirthStateDescription" />
	<xsl:param name="gender" />
	<xsl:param name="genderDescription" />
	<xsl:param name="ssn" />
	<xsl:param name="ssnVerificationStatus" />
	<xsl:param name="ssnVerificationStatusDescription" />
	<xsl:param name="pseudoSsnReason" />
	<xsl:param name="primaryIcn" />
	<xsl:param name="dateOriginalCreation" />
	<xsl:param name="facilityNumberOriginalCreation" />
	<xsl:param name="facilityNameOriginalCreation" />
	<xsl:param name="createdBy" />
	<xsl:param name="resolutionJournalCaseNumber" />
	<xsl:param name="resolutionJournalCaseNumberDescription" />
	<xsl:param name="primaryViewLastUpdated" />
	<xsl:param name="identityTheft" />
	<xsl:param name="identityTheftDescription" />
	<xsl:param name="idState" />
	<xsl:param name="idStateDescription" />
	<xsl:param name="dateOfIdState" />
	<xsl:param name="alias1" />
	<xsl:param name="alias2" />
	<xsl:param name="alias3" />
	<xsl:param name="alias4" />
	<xsl:param name="alias5" />
	<xsl:param name="alias6" />
	<xsl:param name="raceDescription" />
	<xsl:param name="race" />
	<xsl:param name="ethnicityDescription" />
	<xsl:param name="ethnicity" />
	<xsl:param name="facilityName" />
	<xsl:param name="facilityNumber" />
	<xsl:param name="dfn" />
	<xsl:param name="assigningAuthorityName" />
	<xsl:param name="assigningAuthorityNumber" />
	<xsl:param name="dateOfDeath" />
	<xsl:param name="claimNumber" />
	<xsl:param name="dateLastTreated" />
	<xsl:param name="adtHl7Reason" />
	<xsl:param name="dateOfLastUpdatedMessage" />
	<xsl:param name="potentialCatEditStatus" />
	<xsl:param name="potentialCatEditStatusDescription" />
	<xsl:param name="correlationDate" />
	<xsl:param name="identifierStatus" />
	<xsl:param name="identifierStatusDescription" />
	<xsl:param name="maritalStatusDescription" />
	<xsl:param name="maritalStatus" />
	<xsl:param name="streetAddressLine1" />
	<xsl:param name="streetAddressLine2" />
	<xsl:param name="streetAddressLine3" />
	<xsl:param name="residenceCity" />
	<xsl:param name="residenceStateDescription" />
	<xsl:param name="residenceState" />
	<xsl:param name="residenceZip4" />
	<xsl:param name="residencePhoneNumber" />
	<xsl:param name="powStatusIndicatedDescription" />
	<xsl:param name="powStatusIndicated" />
	<xsl:param name="multipleBirthIndicatorDescription" />
	<xsl:param name="multipleBirthIndicator" />
	<xsl:param name="siteAssociation1" />
	<xsl:param name="siteAssociation2" />
	<xsl:param name="siteAssociation3" />
	<xsl:param name="siteAssociation4" />
	<xsl:param name="siteAssociation5" />
	<xsl:param name="siteAssociation6" />
	<xsl:param name="sites" />

	<xsl:template match="/">
		<patient-demographics-response
			xmlns="http://gov/va/nvap/service/pdq">
			<patient-demographics>
				<icn>
					<xsl:value-of select="$icn" />
				</icn>
				<last-name>
					<xsl:value-of select="$lastName" />
				</last-name>
				<first-name>
					<xsl:value-of select="$firstName" />
				</first-name>
				<middle-name>
					<xsl:value-of select="$middleName" />
				</middle-name>
				<prefix>
					<xsl:value-of select="$prefix" />
				</prefix>
				<suffix>
					<xsl:value-of select="$suffix" />
				</suffix>
				<mother-maiden-name>
					<xsl:value-of select="$mothersMaidenName" />
				</mother-maiden-name>
				<dob>
					<xsl:value-of select="$dob" />
				</dob>
				<place-of-birth-city>
					<xsl:value-of select="$placeOfBirthCity" />
				</place-of-birth-city>
				<place-of-birth-state>
					<xsl:value-of select="$placeOfBirthState" />
				</place-of-birth-state>
				<place-of-birth-state-description>
					<xsl:value-of
						select="$placeOfBirthStateDescription" />
				</place-of-birth-state-description>
				<gender>
					<xsl:value-of select="$gender" />
				</gender>
				<gender-description>
					<xsl:value-of select="$genderDescription" />
				</gender-description>
				<ssn>
					<xsl:value-of select="$ssn" />
				</ssn>
				<ssn-verification-status>
					<xsl:value-of select="$ssnVerificationStatus" />
				</ssn-verification-status>
				<ssn-verification-status-description>
					<xsl:value-of
						select="$ssnVerificationStatusDescription" />
				</ssn-verification-status-description>
				<pseudo-ssn-reason>
					<xsl:value-of select="$pseudoSsnReason" />
				</pseudo-ssn-reason>
				<primary-icn>
					<xsl:value-of select="$primaryIcn" />
				</primary-icn>
				<date-original-creation>
					<xsl:value-of select="$dateOriginalCreation" />
				</date-original-creation>
				<facility-number-original-creation>
					<xsl:value-of
						select="$facilityNumberOriginalCreation" />
				</facility-number-original-creation>
				<facility-name-original-creation>
					<xsl:value-of
						select="$facilityNameOriginalCreation" />
				</facility-name-original-creation>
				<created-by>
					<xsl:value-of select="$createdBy" />
				</created-by>
				<resolution-journal-case-number>
					<xsl:value-of select="$resolutionJournalCaseNumber" />
				</resolution-journal-case-number>
				<resolution-journal-case-number-description>
					<xsl:value-of
						select="$resolutionJournalCaseNumberDescription" />
				</resolution-journal-case-number-description>
				<primary-view-last-updated>
					<xsl:value-of select="$primaryViewLastUpdated" />
				</primary-view-last-updated>
				<identity-theft>
					<xsl:value-of select="$identityTheft" />
				</identity-theft>
				<identity-theft-description>
					<xsl:value-of select="$identityTheftDescription" />
				</identity-theft-description>
				<id-state>
					<xsl:value-of select="$idState" />
				</id-state>
				<id-state-description>
					<xsl:value-of select="$idStateDescription" />
				</id-state-description>
				<date-of-id-state>
					<xsl:value-of select="$dateOfIdState" />
				</date-of-id-state>
				<alias1>
					<xsl:value-of select="$alias1" />
				</alias1>
				<alias2>
					<xsl:value-of select="$alias2" />
				</alias2>
				<alias3>
					<xsl:value-of select="$alias3" />
				</alias3>
				<alias4>
					<xsl:value-of select="$alias4" />
				</alias4>
				<alias5>
					<xsl:value-of select="$alias5" />
				</alias5>
				<alias6>
					<xsl:value-of select="$alias6" />
				</alias6>
				<race-description>
					<xsl:value-of select="$raceDescription" />
				</race-description>
				<race>
					<xsl:value-of select="$race" />
				</race>
				<ethnicity-description>
					<xsl:value-of select="$ethnicityDescription" />
				</ethnicity-description>
				<ethnicity>
					<xsl:value-of select="$ethnicity" />
				</ethnicity>
				<facility-name>
					<xsl:value-of select="$facilityName" />
				</facility-name>
				<facility-number>
					<xsl:value-of select="$facilityNumber" />
				</facility-number>
				<dfn>
					<xsl:value-of select="$dfn" />
				</dfn>
				<assigning-authority-name>
					<xsl:value-of select="$assigningAuthorityName" />
				</assigning-authority-name>
				<assigning-authority-number>
					<xsl:value-of select="$assigningAuthorityNumber" />
				</assigning-authority-number>
				<date-of-death>
					<xsl:value-of select="$dateOfDeath" />
				</date-of-death>
				<claim-number>
					<xsl:value-of select="$claimNumber" />
				</claim-number>
				<date-last-treated>
					<xsl:value-of select="$dateLastTreated" />
				</date-last-treated>
				<adt-hl7-reason>
					<xsl:value-of select="$adtHl7Reason" />
				</adt-hl7-reason>
				<date-of-last-updated-message>
					<xsl:value-of select="$dateOfLastUpdatedMessage" />
				</date-of-last-updated-message>
				<potential-cat-edit-status>
					<xsl:value-of select="$potentialCatEditStatus" />
				</potential-cat-edit-status>
				<potential-cat-edit-status-description>
					<xsl:value-of
						select="$potentialCatEditStatusDescription" />
				</potential-cat-edit-status-description>
				<correlation-date>
					<xsl:value-of select="$correlationDate" />
				</correlation-date>
				<identifier-status>
					<xsl:value-of select="$identifierStatus" />
				</identifier-status>
				<identifier-status-description>
					<xsl:value-of select="$identifierStatusDescription" />
				</identifier-status-description>
				<marital-status-description>
					<xsl:value-of select="$maritalStatusDescription" />
				</marital-status-description>
				<marital-status>
					<xsl:value-of select="$maritalStatus" />
				</marital-status>
				<street-address-line1>
					<xsl:value-of select="$streetAddressLine1" />
				</street-address-line1>
				<street-address-line2>
					<xsl:value-of select="$streetAddressLine2" />
				</street-address-line2>
				<street-address-line3>
					<xsl:value-of select="$streetAddressLine3" />
				</street-address-line3>
				<residence-city>
					<xsl:value-of select="$residenceCity" />
				</residence-city>
				<residence-state-description>
					<xsl:value-of select="$residenceStateDescription" />
				</residence-state-description>
				<residence-state>
					<xsl:value-of select="$residenceState" />
				</residence-state>
				<residence-zip4>
					<xsl:value-of select="$residenceZip4" />
				</residence-zip4>
				<residence-phone-number>
					<xsl:value-of select="$residencePhoneNumber" />
				</residence-phone-number>
				<pow-status-indicated-description>
					<xsl:value-of
						select="$powStatusIndicatedDescription" />
				</pow-status-indicated-description>
				<pow-status-indicated>
					<xsl:value-of select="$powStatusIndicated" />
				</pow-status-indicated>
				<multiple-birth-indicator-description>
					<xsl:value-of
						select="$multipleBirthIndicatorDescription" />
				</multiple-birth-indicator-description>
				<multiple-birth-indicator>
					<xsl:value-of select="$multipleBirthIndicator" />
				</multiple-birth-indicator>
				<site-association1>
					<xsl:value-of select="$siteAssociation1" />
				</site-association1>
				<site-association2>
					<xsl:value-of select="$siteAssociation2" />
				</site-association2>
				<site-association3>
					<xsl:value-of select="$siteAssociation3" />
				</site-association3>
				<site-association4>
					<xsl:value-of select="$siteAssociation4" />
				</site-association4>
				<site-association5>
					<xsl:value-of select="$siteAssociation5" />
				</site-association5>
				<site-association6>
					<xsl:value-of select="$siteAssociation6" />
				</site-association6>
			</patient-demographics>
			<!--
				<error>
				<error-code>error-code</error-code>
				<error-description>error-description</error-description>
				</error>
			-->
		</patient-demographics-response>
	</xsl:template>
</xsl:stylesheet>
