<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:util="vap://gov.va.nvap.common.xsl.util"
  xmlns:removePatientCorrelation="http://gov/va/nvap/service/pdq"
  exclude-result-prefixes="util removePatientCorrelation"
>
  <!-- Process the common templates -->
  <xsl:import href="/gov/va/nvap/common/xsl/Common.xsl" />
  <xsl:param name="mpiSendingFacilityNameSpaceID" />
  <xsl:param name="hl7ProcessingId" />
  <xsl:template
    match="//*[local-name()='remove-patient-correlation-request' and namespace-uri()='http://gov/va/nvap/service/pdq']"
  >
    <ADT_A37>
      <MSH>
        <MSH.1>^</MSH.1>
        <MSH.2>~|\&amp;</MSH.2>
        <MSH.3>
          <HD.1>MPIF TRIGGER</HD.1>
        </MSH.3>
        <MSH.4>
          <HD.1>
            <xsl:value-of select="$mpiSendingFacilityNameSpaceID" />
          </HD.1>
        </MSH.4>
        <MSH.5>
          <HD.1>MPIF TRIGGER</HD.1>
        </MSH.5>
        <MSH.6>
          <HD.1>200M</HD.1>
        </MSH.6>
        <MSH.7>
          <TS.1>
            <xsl:value-of select="util:getCurrentDateTimeyyyyMMddHHmmss()" />
          </TS.1>
        </MSH.7>
        <MSH.9>
          <MSG.1>ADT</MSG.1>
          <MSG.2>A37</MSG.2>
        </MSH.9>
        <MSH.10>
          <xsl:value-of select="util:generateUUID()" />
        </MSH.10>
        <MSH.11>
          <PT.1>
            <xsl:value-of select="$hl7ProcessingId" />
          </PT.1>
        </MSH.11>
        <MSH.12>
          <VID.1>2.4</VID.1>
        </MSH.12>
        <MSH.15>AL</MSH.15>
        <MSH.16>AL</MSH.16>
      </MSH>
      <EVN>
        <EVN.2>
          <TS.1>
            <xsl:value-of select="util:getCurrentDateTimeyyyyMMddHHmmss()" />
          </TS.1>
        </EVN.2>
        <EVN.5>
          <XCN.1>""</XCN.1>
        </EVN.5>
      </EVN>
      <PID>
        <PID.1>1</PID.1>
        <PID.3>
          <CX.4>
            <HD.1>USVHA</HD.1>
            <HD.3>0363</HD.3>
          </CX.4>
          <CX.5>NI</CX.5>
          <CX.6>
            <HD.1>VA FACILITY ID</HD.1>
            <HD.2>200M</HD.2>
            <HD.3>L</HD.3>
          </CX.6>
        </PID.3>
        <PID.3>
          <CX.1>
            <xsl:value-of select="removePatientCorrelation:correlated-patient-id" />
          </CX.1>
          <CX.4>
            <HD.2>
              <xsl:value-of select="removePatientCorrelation:correlated-assigning-authority-name" />
            </HD.2>
            <HD.3>ISO</HD.3>
          </CX.4>
          <CX.6>
            <xsl:if test="removePatientCorrelation:correlated-assigning-authority-name">
              <HD.2>
                <xsl:value-of select="removePatientCorrelation:correlated-assigning-authority-oid" />
              </HD.2>
            </xsl:if>
            <HD.3>ISO</HD.3>
          </CX.6>
        </PID.3>
        <PID.5>
          <XPN.1>
            <FN.1>
              <xsl:value-of select="removePatientCorrelation:patient-last-name" />
            </FN.1>
          </XPN.1>
          <XPN.2>
            <xsl:value-of select="removePatientCorrelation:patient-first-name" />
          </XPN.2>
          <XPN.3>
            <xsl:value-of select="removePatientCorrelation:patient-middle-name" />
          </XPN.3>
          <XPN.7>L</XPN.7>
        </PID.5>
      </PID>
      <PD1 />
      <PV1 />
      <DB1 />
      <PID>
        <PID.1>2</PID.1>
        <PID.3>
          <CX.1>
            <xsl:value-of select="removePatientCorrelation:patient-id" />
          </CX.1>
          <CX.4>
            <HD.1>USVHA</HD.1>
            <HD.3>0363</HD.3>
          </CX.4>
          <CX.5>NI</CX.5>
          <CX.6>
            <HD.1>VA FACILITY ID</HD.1>
            <HD.2>200M</HD.2>
            <HD.3>L</HD.3>
          </CX.6>
        </PID.3>
        <PID.3>
          <CX.1>
            <xsl:value-of select="removePatientCorrelation:correlated-patient-id" />
          </CX.1>
          <CX.4>
            <HD.2>
              <xsl:value-of select="removePatientCorrelation:correlated-assigning-authority-name" />
            </HD.2>
            <HD.3>ISO</HD.3>
          </CX.4>
          <CX.6>
            <xsl:if test="removePatientCorrelation:correlated-assigning-authority-name">
              <HD.2>
                <xsl:value-of select="removePatientCorrelation:correlated-assigning-authority-oid" />
              </HD.2>
            </xsl:if>
            <HD.3>ISO</HD.3>
          </CX.6>
        </PID.3>
        <PID.5>
          <XPN.1>
            <FN.1>
              <xsl:value-of select="removePatientCorrelation:patient-last-name" />
            </FN.1>
          </XPN.1>
          <XPN.2>
            <xsl:value-of select="removePatientCorrelation:patient-first-name" />
          </XPN.2>
          <XPN.3>
            <xsl:value-of select="removePatientCorrelation:patient-middle-name" />
          </XPN.3>
          <XPN.7>L</XPN.7>
        </PID.5>
      </PID>
    </ADT_A37>
  </xsl:template>
</xsl:stylesheet>
