<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:util="vap://gov.va.nvap.common.xsl.util"
	xmlns:patientMatchQuery="http://gov/va/nvap/service/pdq"
	exclude-result-prefixes="util patientMatchQuery">

	<!-- Process the common templates -->
	<xsl:import href="/gov/va/nvap/common/xsl/Common.xsl" />

	<xsl:param name="mpiSendingFacilityNameSpaceID" />
	<xsl:param name="numberOfMatches" />
	<xsl:param name="hl7ProcessingId" />

	<xsl:template
		match="//*[local-name()='patient-match-query' and namespace-uri()='http://gov/va/nvap/service/pdq']">
		<QBP_Q22>
			<MSH>
				<MSH.1>^</MSH.1>
				<MSH.2>~|\&amp;</MSH.2>
				<MSH.3>
					<HD.1>NHIN</HD.1>
				</MSH.3>
				<MSH.4>
					<HD.1>
						<xsl:value-of
							select="$mpiSendingFacilityNameSpaceID" />
					</HD.1>
				</MSH.4>
				<MSH.5>
					<HD.1>MPI</HD.1>
				</MSH.5>
				<MSH.6>
					<HD.1>200M</HD.1>
				</MSH.6>
				<MSH.7>
					<TS.1>
						<xsl:value-of select="util:getCurrentDateTimeyyyyMMddHHmmss()" />
					</TS.1>
				</MSH.7>
				<MSH.9>
					<MSG.1>QBP</MSG.1>
					<MSG.2>Q22</MSG.2>
				</MSH.9>
				<MSH.10>
					<xsl:value-of select="util:generateUUID()" />
				</MSH.10>
				<MSH.11>
					<PT.1>
						<xsl:value-of select="$hl7ProcessingId" />
					</PT.1>
				</MSH.11>
				<MSH.12>
					<VID.1>2.4</VID.1>
				</MSH.12>
				<MSH.15>NE</MSH.15>
				<MSH.16>AL</MSH.16>
			</MSH>
			<QPD>
				<QPD.1>
					<CE.1>Q22</CE.1>
					<CE.2>Find Candidates</CE.2>
					<CE.3>HL72.4</CE.3>
				</QPD.1>
				<QPD.2>1</QPD.2>
				<QPD.3>
					<UNKNOWN.1>@PID.5</UNKNOWN.1>
					<UNKNOWN.2>
						<xsl:value-of
							select="patientMatchQuery:patient-profile/patientMatchQuery:last-name" />
					</UNKNOWN.2>
					<UNKNOWN.3>
						<xsl:value-of
							select="patientMatchQuery:patient-profile/patientMatchQuery:first-name" />
					</UNKNOWN.3>
					<UNKNOWN.8>L</UNKNOWN.8>
				</QPD.3>
				<QPD.3>
					<UNKNOWN.1>@PID.11</UNKNOWN.1>
					<UNKNOWN.8>P</UNKNOWN.8>
				</QPD.3>
				<QPD.3>@PID.7</QPD.3>
				<QPD.3>@PID.8</QPD.3>
				<QPD.3>
					<UNKNOWN.1>@PID.3</UNKNOWN.1>
					<UNKNOWN.2>
						<xsl:value-of
							select="patientMatchQuery:patient-profile/patientMatchQuery:ssn" />
					</UNKNOWN.2>
					<UNKNOWN.5>
						<UNKNOWN.1>USSSA</UNKNOWN.1>
						<UNKNOWN.3>0363</UNKNOWN.3>
					</UNKNOWN.5>
					<UNKNOWN.6>SS</UNKNOWN.6>
					<UNKNOWN.7>
						<UNKNOWN.1>VA FACILITY ID</UNKNOWN.1>
						<UNKNOWN.2>200CPP</UNKNOWN.2>
						<UNKNOWN.3>L</UNKNOWN.3>
					</UNKNOWN.7>
				</QPD.3>
				<QPD.3>
					<UNKNOWN.1>@PID.13</UNKNOWN.1>
					<UNKNOWN.3>PRN</UNKNOWN.3>
					<UNKNOWN.4>PH</UNKNOWN.4>
				</QPD.3>
				<QPD.4>INITIATE</QPD.4>
				<QPD.5>7.5</QPD.5>
				<QPD.6>NT</QPD.6>
			</QPD>
			<RCP>
				<RCP.1>I</RCP.1>
				<RCP.2>
					<CQ.1>
						<xsl:value-of select="$numberOfMatches" />
					</CQ.1>
					<CQ.2>
						<CE.1>RD</CE.1>
					</CQ.2>
				</RCP.2>
				<RCP.3>
					<CE.1>R</CE.1>
				</RCP.3>
				<RCP.5>N</RCP.5>
			</RCP>
		</QBP_Q22>
	</xsl:template>
</xsl:stylesheet>
