package gov.va.nvap.server.service.privacy.emailer;

import gov.va.nvap.server.service.privacy.emailer.EmailBean;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.lang.StringBuffer;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeMessage;


public class Emailer {
	private final static String SMTP_AUTH = "mail.smtp.auth";
	private final static String SMTP_STARTTLS = "mail.smtp.starttls.enable";
	private final static String SMTP_HOST = "mail.smtp.host";
	private final static String SMTP_PORT = "mail.smtp.port";
	
	private final static String SUBJECT = "subject";
	private final static String BODY = "body";
	private final static String REPORT_PATTERN = "%report%";
	
    /**
     * @param distributionList List of email addresses and/or contact groups separated by semicolon
     * @param messageAttributes Map of message attributes, keyed by attribute name. Currently supported keys are:
     *                          "subject"
     *                          "body" 
     * @param report List of items in the report. If "body" attribute contains "%report%" stub, generated tabular representation
     *                of the report will substitute the stub; otherwise, it will be appended at the end of the "body" attribute.
     * @return true, if email messages are sent correctly;
     *          false, if at least one send operation fails
     */
    final public boolean emailReport(String distributionList, Map<String, String> messageAttributes,
    		List<Map<String, Object>> report) {
        boolean retValue = true;
        EmailBean emailBean = EmailBean.getInstance();
        final String username = emailBean.getFrom();
        final String password = emailBean.getPassword();
        final String reportLink = emailBean.getLink();

        Properties props = new Properties();
        props.put(SMTP_AUTH, "true");
        props.put(SMTP_STARTTLS, "true");
        props.put(SMTP_HOST, emailBean.getHost());
        props.put(SMTP_PORT, emailBean.getPort());

        Session session = Session.getInstance(props,
          new javax.mail.Authenticator() {
                protected PasswordAuthentication getPasswordAuthentication() {
                       return new PasswordAuthentication(username, password);
                }
          });

        try {
                MimeMessage message = new MimeMessage(session);
                message.setFrom(new InternetAddress(emailBean.getFrom()));                               
                addRecipients(message, distributionList);
   	                        
                message.setSubject(messageAttributes.get(SUBJECT));
                
                MimeBodyPart bodyText = new MimeBodyPart();
                
                
                InternetHeaders headers = new InternetHeaders();
                headers.addHeader("Content-type", "text/html; charset=UTF-8");
                bodyText.setText(messageAttributes.get(BODY) + reportLink);
                MimeMultipart body = new MimeMultipart();
                body.addBodyPart(bodyText);                                    	      
                message.setContent(body);
                Transport.send(message);
        } catch (MessagingException e) {
                retValue = false;
        }
        return retValue;
    }

    /**
     * @param distributionList List of email addresses and/or contact groups separated by semicolon
     * @param messageAttributes Map of message attributes, keyed by attribute name. Currently supported keys are:
     *                          "subject"
     *                          "body" 
     */
    private void addRecipients(MimeMessage message, String distributionList)
    		throws MessagingException{    	
    	String[] list = distributionList.split(";");
    	for (int i=0; i<list.length; i++){
    		 message.addRecipient(Message.RecipientType.TO,
                     new InternetAddress(list[i]));
    	}
    }

    /**
     * @param reportList List of items in the report. If "body" attribute contains "%report%" stub, generated tabular representation
     *                of the report will substitute the stub; otherwise, it will be appended at the end of the "body" attribute.
     * @return The report;
     */
    private String getTabReport(List<Map<String, Object>> reportList){
    	Iterator<Map<String, Object>> iter = reportList.iterator();
		StringBuffer report = new StringBuffer();
    	while(iter.hasNext()){
			Map<String, Object> map = iter.next();
			for(Map.Entry<String, Object> entry : map.entrySet()){
				report.append(entry.getValue().toString()).append("\n");
			}
		}
    	return report.toString();
    }
}
