package gov.va.nvap.server.service.privacy.emailer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class EmailBean {
	public String subject;
	public String body;
	public String from;
	public String host;
	public String username;
	public String password;
	public String port;
	public String link;
	private static EmailBean emailBean;
	
	
	private EmailBean(){
		Properties props = new Properties();
		String fileName = "email.properties";
		InputStream inputStream = null;
		try {
			inputStream = getClass().getClassLoader().getResourceAsStream(fileName);
			props.load(inputStream);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally {
            if (inputStream != null) {
            	try {
                	inputStream.close();
        		} catch (IOException e) {
        			// TODO Auto-generated catch block
        			e.printStackTrace();
        		}

            }
        }
		setSubject(props.getProperty("email.subject"));
		setBody(props.getProperty("email.body"));
		setFrom(props.getProperty("email.from"));
		setHost(props.getProperty("email.host"));
		setUsername(props.getProperty("email.username"));
		setPassword(props.getProperty("email.password"));
		setPort(props.getProperty("email.port"));
		setLink(props.getProperty("email.link"));
	}
	
	public static synchronized EmailBean  getInstance(){		
		if ( emailBean == null ){
			emailBean = new EmailBean();
		}
		return emailBean;
	}
	
	
	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getFrom() {
		return from;
	}
	
	public void setFrom(String from) {
		this.from = from;
	}
	
	public String getHost() {
		return host;
	}
	public void setHost(String host) {
		this.host = host;
	}
	public String getUsername() {
		return username;
	}
	public void setUsername(String username) {
		this.username = username;
	}
	public String getPassword() {
		return password;
	}
	public void setPassword(String password) {
		this.password = password;
	}
	public String getPort() {
		return port;
	}
	public void setPort(String port) {
		this.port = port;
	}
	public String getLink() {
		return link;
	}
	public void setLink(String link) {
		this.link = link;
	}
	
}
