package gov.va.nvap.server.service.privacy.converter;

import gov.va.nvap.svc.consentmgmt.stub.data.PurposeOfUse;

import org.dozer.CustomConverter;
import org.dozer.MappingException;

/**
 * A Dozer custom converter for converting Optout reason from PIP to Webservice
 * type.
 *
 * @author Asha Amritraj
 *
 */
public class PurposeOfUseTypeConverter implements CustomConverter {

	@Override
	public Object convert(final Object destination, final Object source,
			final Class<?> destClass, final Class<?> sourceClass) {
		if (source == null) {
			return null;
		}
		if (PurposeOfUse.class.isInstance(source)) {
			// From PIP to WS Type
			final String text = ((PurposeOfUse) source).getPouValue();
			return gov.va.nvap.privacy.PurposeOfUseType.fromValue(text);
		}
		// From WS Type to PIP
		// TODO: cannot get the ID of ConsentType, so for now its not
		// implemented.
		else {
			throw new MappingException(
					"Converter PurposeOfUseTypeConverter used incorrectly. Arguments passed in were:"
							+ destination + " and " + source);
		}
	}
}
