package gov.va.nvap.server.service.privacy.converter;

import gov.va.nvap.privacy.ConsentDirectiveOptOutReasonType;
import gov.va.nvap.svc.consentmgmt.stub.data.OptoutReason;

import org.dozer.CustomConverter;
import org.dozer.MappingException;

/**
 * A Dozer custom converter for converting Optout reason from PIP to Webservice
 * type.
 * 
 * @author Asha Amritraj
 * 
 */
public class OptoutReasonConverter implements CustomConverter {

	@Override
	public Object convert(final Object destination, final Object source,
			final Class<?> destClass, final Class<?> sourceClass) {
		if (source == null) {
			return null;
		}
		if (OptoutReason.class.isInstance(source)) {
			// From PIP to WS Type
			final String text = ((OptoutReason) source).getText();
			return ConsentDirectiveOptOutReasonType.fromValue(text);
		}
		// From WS Type to PIP
		// TODO: cannot get the ID of optoutreason, so for now its not
		// implemented.
		// else if (ConsentDirectiveOptOutReasonType.class.isInstance(source)) {
		// OptoutReason optoutReason = new OptoutReason();
		// optoutReason.setText(((ConsentDirectiveOptOutReasonType)
		// source).value());
		// return optoutReason;
		// }
		else {
			throw new MappingException(
					"Converter OptoutReasonConverter used incorrectly. Arguments passed in were:"
							+ destination + " and " + source);
		}
	}

}
