package gov.va.nvap.server.service.privacy.converter;

import gov.va.nvap.svc.consentmgmt.stub.data.ConsentType;

import org.dozer.CustomConverter;
import org.dozer.MappingException;

/**
 * A Dozer custom converter for converting Optout reason from PIP to Webservice
 * type.
 *
 * @author Asha Amritraj
 *
 */
public class ConsentTypeConverter implements CustomConverter {

    // For now assign consent type IDs as constants
    // Not complete list
    private static final Long NWHIN_AUTH_ID = 100L;
    private static final Long NWHIN_REVOC_ID = 101L;
    private static final Long SSA_AUTH_ID = 102L;
    private static final Long SSA_REVOC_ID = 103L;
    
	@Override
	public Object convert(final Object destination, final Object source,
			final Class<?> destClass, final Class<?> sourceClass) {
		if (source == null) {
			return null;
		}
		if (ConsentType.class.isInstance(source)) {
			// From PIP to WS Type
			final String text = ((ConsentType) source).getName();
			return gov.va.nvap.privacy.ConsentType.fromValue(text);
		} else if (gov.va.nvap.privacy.ConsentType.class.isInstance(source)){
            ConsentType newConsentType = new ConsentType();
            newConsentType.setName(((gov.va.nvap.privacy.ConsentType) source).value());
            
            if (newConsentType.getName().equalsIgnoreCase("NwHIN Authorization")) {
                newConsentType.setConsentTypeId(NWHIN_AUTH_ID);
            } else if (newConsentType.getName().equalsIgnoreCase("NwHIN Revocation")) {
                newConsentType.setConsentTypeId(NWHIN_REVOC_ID);
            } else if (newConsentType.getName().equalsIgnoreCase("SSA Authorization")) {
                newConsentType.setConsentTypeId(SSA_AUTH_ID);
            } else if (newConsentType.getName().equalsIgnoreCase("SSA Revocation")) {
                newConsentType.setConsentTypeId(SSA_REVOC_ID);
            }
            
            return newConsentType;
        } else {
			throw new MappingException(
					"Converter ConsentTypeConverter used incorrectly. Arguments passed in were:"
							+ destination + " and " + source);
		}
	}
}
