package gov.va.nvap.server.service.privacy;

import gov.va.nvap.privacy.ConsentDirectiveDetailedExpirationRequest;
import gov.va.nvap.privacy.ExpiringConsentConfigurationRequest;
import gov.va.nvap.privacy.ExpiringConsentConfigurationResponse;
import gov.va.nvap.privacy.ExpiringConsentLetterResponse;
import gov.va.nvap.server.auth.ServiceAuthentication;
import gov.va.nvap.service.auth.ServiceAudit;
import gov.va.nvap.service.auth.ServiceAuthenticationException;
import gov.va.nvap.service.privacy.ExpiringConsentService;
import javax.annotation.Resource;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.Interceptors;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.BindingType;
import javax.xml.ws.WebServiceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

@SuppressWarnings("all")
@WebService(portName = "ExpiringConsentPort", name = "ExpiringConsentPortType", 
	serviceName = "ExpiringConsentService", targetNamespace = "http://gov.va.nvap.service.privacy/", 
	wsdlLocation = "META-INF/xml-resources/web-services/ConsentManagementService/wsdl/ExpiringConsentService.wsdl")
@BindingType("http://schemas.xmlsoap.org/wsdl/soap/http")
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
@Stateless(name = "ExpiringConsentService", mappedName = "ExpiringConsentService")
@Remote(ExpiringConsentService.class)
@Interceptors(SpringBeanAutowiringInterceptor.class)
@TransactionAttribute(TransactionAttributeType.REQUIRED)
public class ExpiringConsentServicePort implements ExpiringConsentService {

	/**
	 * Inject Spring bean, so that we have all dependencies injected.
	 */
	@Autowired
	@Qualifier(value = "ExpiringConsentService")
	private ExpiringConsentService expiringConsentService;
        @Autowired
        private ApplicationContext applicationContext;
        @Resource
        private WebServiceContext context;
        private ServiceAuthentication auth = new ServiceAuthentication();
        
	public ExpiringConsentServicePort() {
	}
	/**
	 * @param expiringConsentConfigurationRequest
	 * @return returns gov.va.nvap.privacy.
	 *         ExpiringConsentConfigurationResponseType
	 */
	@WebMethod(operationName = "GetConfiguration")
	@WebResult(name = "ExpiringConsentConfigurationResponse", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ExpiringConsentConfigurationResponse")
	public ExpiringConsentConfigurationResponse getConfiguration(
			@WebParam(name = "ExpiringConsentConfigurationRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ExpiringConsentConfigurationRequest") final ExpiringConsentConfigurationRequest expiringConsentConfigurationRequest)
			{
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
                
        try {
            sa = auth.checkAuth(context, applicationContext, "getConfiguration");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }
        
        long startTime = System.currentTimeMillis();
        
		try {
			return this.expiringConsentService.getConfiguration(expiringConsentConfigurationRequest);
		} catch (final Exception ex) {
			success = 0;
			return null;
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}
	
	@WebMethod(operationName = "UpdateConfiguration")
	public void updateConfiguration(
			@WebParam(name = "ExpiringConsentConfigurationRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ExpiringConsentConfigurationRequest") final ExpiringConsentConfigurationRequest expiringConsentConfigurationRequest)
	{
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try {
            sa = auth.checkAuth(context, applicationContext, "updateConfiguration");
        } catch (ServiceAuthenticationException ex) {
            return;
        }
        
        long startTime = System.currentTimeMillis();
        
		try {
			this.expiringConsentService.updateConfiguration(expiringConsentConfigurationRequest);
		} catch (final Exception ex) {
			success = 0;	
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}
	
	@WebMethod(operationName = "SendReport")
	public void sendReport(
			@WebParam(name = "ExpiringConsentConfigurationRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ExpiringConsentConfigurationRequest") final ExpiringConsentConfigurationRequest expiringConsentConfigurationRequest)
	{
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try {
            sa = auth.checkAuth(context, applicationContext, "sendReport");
        } catch (ServiceAuthenticationException ex) {
            return;
        }
        
        long startTime = System.currentTimeMillis();
        
		try {
			this.expiringConsentService.sendReport(expiringConsentConfigurationRequest);
		} catch (final Exception ex) {
			success = 0;
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}
    
    @WebMethod(operationName = "GetReportLetters")
    @Override
    @WebResult(name = "ExpiringConsentLetterResponse", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ExpiringConsentLetterResponse")
	public ExpiringConsentLetterResponse getReportLetters(
			@WebParam(name = "ConsentDirectiveExpirationRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveExpirationRequest") final ConsentDirectiveDetailedExpirationRequest consentDirectiveExpirationRequest)
	{
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try {
            sa = auth.checkAuth(context, applicationContext, "getReportLetters");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }
        
        long startTime = System.currentTimeMillis();
        
		try {
			return this.expiringConsentService.getReportLetters(consentDirectiveExpirationRequest);
		} catch (final Exception ex) {
            success = 0;
            return null;
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}
}