package gov.va.nvap.server.service.privacy;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.privacy.ConsentDirectiveAuthorizationRequest;
import gov.va.nvap.privacy.ConsentDirectiveAuthorizationResponse;
import gov.va.nvap.privacy.ConsentDirectiveDetailedExpirationRequest;
import gov.va.nvap.privacy.ConsentDirectiveDetailedExpirationResponse;
import gov.va.nvap.privacy.ConsentDirectiveDocumentRetrieveRequest;
import gov.va.nvap.privacy.ConsentDirectiveDocumentRetrieveResponse;
import gov.va.nvap.privacy.ConsentDirectiveQueryRequest;
import gov.va.nvap.privacy.ConsentDirectiveQueryResponse;
import gov.va.nvap.privacy.ConsentDirectiveRevocationRequest;
import gov.va.nvap.privacy.ConsentDirectiveRevocationResponse;
import gov.va.nvap.privacy.ConsentDirectiveUpdateRequest;
import gov.va.nvap.privacy.ConsentDirectiveUpdateResponse;
import gov.va.nvap.privacy.ConsentManagementServiceFaultType;
import gov.va.nvap.privacy.OrganizationTrustedSourceRequest;
import gov.va.nvap.privacy.OrganizationTrustedSourceResponse;
import gov.va.nvap.privacy.OrganizationsQueryRequest;
import gov.va.nvap.privacy.OrganizationsQueryResponse;
import gov.va.nvap.privacy.RestrictionsQueryRequest;
import gov.va.nvap.privacy.RestrictionsQueryResponse;
import gov.va.nvap.privacy.StatusQueryRequest;
import gov.va.nvap.privacy.StatusQueryResponse;
import gov.va.nvap.server.auth.ServiceAuthentication;
import gov.va.nvap.service.auth.ServiceAudit;
import gov.va.nvap.service.auth.ServiceAuthenticationException;
import gov.va.nvap.service.privacy.ConsentManagementService;
import gov.va.nvap.service.privacy.ConsentManagementServiceException;
import gov.va.nvap.service.privacy.ConsentManagementServiceFaultMessage;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentDirective;
import javax.annotation.Resource;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.Interceptors;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.BindingType;
import javax.xml.ws.WebServiceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;
//import gov.va.nvap.server.endpoint.mvi.MviSoapEndpoint;

/**
 * Consent Management WebService.
 * 
 * @author Asha Amritraj
 */
@SuppressWarnings("all")
@WebService(portName = "ConsentManagementPort", name = "ConsentManagementPortType", serviceName = "ConsentManagementService", targetNamespace = "http://gov.va.nvap.service.privacy/", wsdlLocation = "META-INF/xml-resources/web-services/ConsentManagementService/wsdl/ConsentManagementService.wsdl")
@BindingType("http://schemas.xmlsoap.org/wsdl/soap/http")
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
@Stateless(name = "ConsentManagementService", mappedName = "ConsentManagementService")
@Remote(ConsentManagementService.class)
@Interceptors(SpringBeanAutowiringInterceptor.class)
@TransactionAttribute(TransactionAttributeType.REQUIRED)
public class ConsentManagementServicePort implements ConsentManagementService {

	/**
	 * Inject Spring bean, so that we have all dependencies injected.
	 */
	@Autowired
	@Qualifier(value = "ConsentManagementService")
	private ConsentManagementService consentManagementService;
    @Autowired
    private ApplicationContext applicationContext;
    //@Autowired
    //private MviSoapEndpoint mviSoapEndpoint;
    @Resource
    private WebServiceContext context;
    private ServiceAuthentication auth = new ServiceAuthentication();
    
	public ConsentManagementServicePort() {
	}

	/**
	 * @param consentDirectiveDocumentRetrieveRequest
	 * @return returns gov.va.nvap.privacy.
	 *         ConsentDirectiveDocumentRetrieveResponseType
	 * @throws ConsentManagementServiceFaultMessage
	 */
	@WebMethod(operationName = "GetConsentDirectiveDocuments")
	@WebResult(name = "ConsentDirectiveDocumentRetrieveResponse", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveDocumentRetrieveResponse")
	public ConsentDirectiveDocumentRetrieveResponse getConsentDirectiveDocuments(
			@WebParam(name = "ConsentDirectiveDocumentRetrieveRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveDocumentRetrieveRequest") final ConsentDirectiveDocumentRetrieveRequest consentDirectiveDocumentRetrieveRequest)
			throws ConsentManagementServiceFaultMessage {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        // Check to see if we have a DoD EDIPI instead of ICN
        String identifier = this.translatePatientIdentifier(consentDirectiveDocumentRetrieveRequest.getConsentDirectiveReference().getPatientIen());
        consentDirectiveDocumentRetrieveRequest.getConsentDirectiveReference().setPatientIen(identifier);
        
        try {
            sa = auth.checkAuth(context, applicationContext, "getConsentDirectiveDocuments");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }
            
        long startTime = System.currentTimeMillis();
        
		try {
			return this.consentManagementService.getConsentDirectiveDocuments(consentDirectiveDocumentRetrieveRequest);
		} catch (final ConsentManagementServiceException ex) {
			final ConsentManagementServiceFaultType errorType = new ConsentManagementServiceFaultType();
            success = 0;
			throw new ConsentManagementServiceFaultMessage(ex.getMessage(), errorType);
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}

	/**
	 * @param consentDirectiveQueryRequest
	 * @return returns gov.va.nvap.privacy.ConsentDirectiveQueryResponseType
	 * @throws ConsentManagementServiceFaultMessage
	 */
	@WebMethod(operationName = "GetConsentDirectives")
	@WebResult(name = "ConsentDirectiveQueryResponse", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveQueryResponse")
	public ConsentDirectiveQueryResponse getConsentDirectives(
			@WebParam(name = "ConsentDirectiveQueryRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveQueryRequest") final ConsentDirectiveQueryRequest consentDirectiveQueryRequest)
			throws ConsentManagementServiceFaultMessage {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        // Check to see if we have a DoD EDIPI instead of ICN
        String identifier = this.translatePatientIdentifier(consentDirectiveQueryRequest.getPatientId());
        consentDirectiveQueryRequest.setPatientId(identifier);
        
        try {
            sa = auth.checkAuth(context, applicationContext, "getConsentDirectives");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }
        
		long startTime = System.currentTimeMillis();
        
        try {
			return this.consentManagementService.getConsentDirectives(consentDirectiveQueryRequest);
		} catch (final ConsentManagementServiceException ex) {
			final ConsentManagementServiceFaultType errorType = new ConsentManagementServiceFaultType();
            success = 0;
			throw new ConsentManagementServiceFaultMessage(ex.getMessage(),errorType);
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}
	
	/**
	 * @param consentDirectiveExpirationRequest
	 * @return returns gov.va.nvap.privacy.ConsentDirectiveQueryResponseType
	 * @throws ConsentManagementServiceFaultMessage
	 */
	@WebMethod(operationName = "GetExpiringConsentDirectives")
	@WebResult(name = "ConsentDirectiveExpirationResponse", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveExpirationResponse")
	public ConsentDirectiveDetailedExpirationResponse getAllExpiringConsentDirectives(
			@WebParam(name = "ConsentDirectiveExpirationRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveExpirationRequest") final ConsentDirectiveDetailedExpirationRequest consentDirectiveExpirationRequest)
			throws ConsentManagementServiceFaultMessage {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try {
            sa = auth.checkAuth(context, applicationContext, "getAllExpiringConsentDirectives");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }
        
		long startTime = System.currentTimeMillis();
        
        try {
			return this.consentManagementService.getAllExpiringConsentDirectives(consentDirectiveExpirationRequest);
		} catch (final ConsentManagementServiceException ex) {
			final ConsentManagementServiceFaultType errorType = new ConsentManagementServiceFaultType();
            success = 0;
			throw new ConsentManagementServiceFaultMessage(ex.getMessage(),errorType);
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}
    
    @WebMethod(operationName = "GetExpiringDetailedConsentDirectives")
	@WebResult(name = "ConsentDirectiveExpirationResponse", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveExpirationResponse")
	public ConsentDirectiveDetailedExpirationResponse getAllExpiringDetailedConsentDirectives(
			@WebParam(name = "ConsentDirectiveExpirationRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveExpirationRequest") final ConsentDirectiveDetailedExpirationRequest consentDirectiveExpirationRequest)
			throws ConsentManagementServiceFaultMessage {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try {
            sa = auth.checkAuth(context, applicationContext, "getAllExpiringDetailedConsentDirectives");
        } catch (ServiceAuthenticationException ex) {
               return null;
        }
        
        long startTime = System.currentTimeMillis();
        
		try {
			return this.consentManagementService.getAllExpiringDetailedConsentDirectives(consentDirectiveExpirationRequest);
		} catch (final ConsentManagementServiceException ex) {
			final ConsentManagementServiceFaultType errorType = new ConsentManagementServiceFaultType();
            success = 0;
			throw new ConsentManagementServiceFaultMessage(ex.getMessage(), errorType);
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}
    
    @WebMethod(operationName = "GetAuthorizedConsentForSummary")
	@WebResult(name = "ConsentDirectiveExpirationResponse", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveExpirationResponse")
	public ConsentDirectiveDetailedExpirationResponse getAuthorizedConsentForSummary(
			@WebParam(name = "ConsentDirectiveExpirationRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveExpirationRequest") final ConsentDirectiveDetailedExpirationRequest consentDirectiveExpirationRequest)
			throws ConsentManagementServiceFaultMessage {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try {
            sa = auth.checkAuth(context, applicationContext, "getAuthorizedConsentForSummary");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }
        
		long startTime = System.currentTimeMillis();
        
        try {
			return this.consentManagementService.getAuthorizedConsentForSummary(consentDirectiveExpirationRequest);
		} catch (final ConsentManagementServiceException ex) {
			final ConsentManagementServiceFaultType errorType = new ConsentManagementServiceFaultType();
            success = 0;
			throw new ConsentManagementServiceFaultMessage(ex.getMessage(), errorType);
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}

	/**
	 * @param organizationsQueryRequest
	 * @return returns gov.va.nvap.privacy.OrganizationsQueryResponseType
	 * @throws ConsentManagementServiceFaultMessage
	 */
	@WebMethod(operationName = "GetOrganizations")
	@WebResult(name = "OrganizationsQueryResponse", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "OrganizationsQueryResponse")
	public OrganizationsQueryResponse getOrganizations(
			@WebParam(name = "OrganizationsQueryRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "OrganizationsQueryRequest") final OrganizationsQueryRequest organizationsQueryRequest)
			throws ConsentManagementServiceFaultMessage {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try {
            sa = auth.checkAuth(context, applicationContext, "getOrganizations");
        } catch (ServiceAuthenticationException ex) {
            return null;
        } 
        
		long startTime = System.currentTimeMillis();
        
        try {            
			return this.consentManagementService.getOrganizations(organizationsQueryRequest);
		} catch (final ConsentManagementServiceException ex) {
			final ConsentManagementServiceFaultType errorType = new ConsentManagementServiceFaultType();
            success = 0;
			throw new ConsentManagementServiceFaultMessage(ex.getMessage(), errorType);
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}
    
    /**
     * @param organizationTrustedSourceRequest
	 * @return returns gov.va.nvap.privacy.OrganizationTrustedSourceResponseType
	 * @throws ConsentManagementServiceFaultMessage
	 */
    @WebMethod(operationName = "GetIsOrganizationTrustedSource")
    @WebResult(name = "OrganizationTrustedSourceResponse", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "OrganizationTrustedSourceResponse")
    public OrganizationTrustedSourceResponse getIsOrganizationTrustedSource(@WebParam(name = "OrganizationTrustedSourceRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "OrganizationTrustedSourceRequest") final OrganizationTrustedSourceRequest organizationTrustedSourceRequest) throws ConsentManagementServiceFaultMessage {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try {
            sa = auth.checkAuth(context, applicationContext, "getIsOrganizationTrustedSource");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }
        
        long startTime = System.currentTimeMillis();
        
        try {
            if (NullChecker.isEmpty(organizationTrustedSourceRequest.getOrganizationId())) {
                final ConsentManagementServiceFaultType errorType = new ConsentManagementServiceFaultType();
                throw new ConsentManagementServiceFaultMessage("OrganizationId is required.", errorType);
            }
            return this.consentManagementService.getIsOrganizationTrustedSource(organizationTrustedSourceRequest);
        } catch(final ConsentManagementServiceException ex) {
            final ConsentManagementServiceFaultType errorType = new ConsentManagementServiceFaultType();
            success = 0;
			throw new ConsentManagementServiceFaultMessage(ex.getMessage(), errorType);
        } finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
    }
    
	/**
	 * @param consentDirectiveAuthorizationRequest
	 * @return returns gov.va.nvap.privacy.
	 *         ConsentDirectiveAuthorizationResponseType
	 * @throws ConsentManagementServiceFaultMessage
	 */
	@WebMethod(operationName = "ProcessConsentDirectiveAuthorization")
	@WebResult(name = "ConsentDirectiveAuthorizationResponse", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveAuthorizationResponse")
	public ConsentDirectiveAuthorizationResponse processConsentDirectiveAuthorization(
			@WebParam(name = "ConsentDirectiveAuthorizationRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveAuthorizationRequest") final ConsentDirectiveAuthorizationRequest consentDirectiveAuthorizationRequest)
			throws ConsentManagementServiceFaultMessage {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try {
            sa = auth.checkAuth(context, applicationContext, "processConsentDirectiveAuthorization");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }
        
		long startTime = System.currentTimeMillis();
        
        try {
			return this.consentManagementService.processConsentDirectiveAuthorization(consentDirectiveAuthorizationRequest);
		} catch (final ConsentManagementServiceException ex) {
			final ConsentManagementServiceFaultType errorType = new ConsentManagementServiceFaultType();
            success = 0;
			throw new ConsentManagementServiceFaultMessage(ex.getMessage(), errorType);
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}

	/**
	 * @param consentDirectiveRevocationRequest
	 * @return returns gov.va.nvap.privacy.
	 *         ConsentDirectiveRevocationResponseType
	 * @throws ConsentManagementServiceFaultMessage
	 */
	@WebMethod(operationName = "ProcessConsentDirectiveRevocation")
	@WebResult(name = "ConsentDirectiveRevocationResponse", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveRevocationResponse")
	public ConsentDirectiveRevocationResponse processConsentDirectiveRevocation(
			@WebParam(name = "ConsentDirectiveRevocationRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveRevocationRequest") final ConsentDirectiveRevocationRequest consentDirectiveRevocationRequest)
			throws ConsentManagementServiceFaultMessage {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try {
            sa = auth.checkAuth(context, applicationContext, "processConsentDirectiveRevocation");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }
        
        long startTime = System.currentTimeMillis();
        
		try {
			return this.consentManagementService.processConsentDirectiveRevocation(consentDirectiveRevocationRequest);
		} catch (final ConsentManagementServiceException ex) {
			final ConsentManagementServiceFaultType errorType = new ConsentManagementServiceFaultType();
            success = 0;
			throw new ConsentManagementServiceFaultMessage(ex.getMessage(), errorType);
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}

        
			
        
	/**
	 * @param consentDirectiveRevocationRequest
	 * @return returns gov.va.nvap.privacy.
	 *         ConsentDirectiveRevocationResponseType
	 * @throws ConsentManagementServiceFaultMessage
	 */
	@WebMethod(operationName = "ProcessConsentDirectiveUpdate")
	@WebResult(name = "ConsentDirectiveUpdateResponse", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveUpdateResponse")
	public ConsentDirectiveUpdateResponse processConsentDirectiveUpdate(
			@WebParam(name = "ConsentDirectiveUpdateRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "ConsentDirectiveRevocationRequest") final ConsentDirectiveUpdateRequest consentDirectiveUpdateRequest)
			throws ConsentManagementServiceFaultMessage {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try {
            sa = auth.checkAuth(context, applicationContext, "processConsentDirectiveUpdate");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }
        
        long startTime = System.currentTimeMillis();
		
        try {
			return this.consentManagementService.processConsentDirectiveUpdate(consentDirectiveUpdateRequest);
		} catch (final ConsentManagementServiceException ex) {
			final ConsentManagementServiceFaultType errorType = new ConsentManagementServiceFaultType();
            success = 0;
			throw new ConsentManagementServiceFaultMessage(ex.getMessage(), errorType);
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}
          /**
	 * @param RestrictionsQueryRequest
	 * @return returns gov.va.nvap.privacy.RestrictionsQueryResponseType
	 * @throws ConsentManagementServiceFaultMessage
	 */
	@WebMethod(operationName = "GetRestrictions")
	@WebResult(name = "RestrictionsQueryResponse", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "RestrictionsQueryResponse")
	public RestrictionsQueryResponse getRestrictions(
			@WebParam(name = "RestrictionsQueryRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "RestrictionsQueryRequest") final RestrictionsQueryRequest restrictionsQueryRequest)
			throws ConsentManagementServiceFaultMessage {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try {
            sa = auth.checkAuth(context, applicationContext, "GetRestrictions");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }
                
        long startTime = System.currentTimeMillis();
        
		try {
			return this.consentManagementService.getRestrictions(restrictionsQueryRequest);
		} catch (final ConsentManagementServiceException ex) {
			final ConsentManagementServiceFaultType errorType = new ConsentManagementServiceFaultType();
            success = 0;
			throw new ConsentManagementServiceFaultMessage(ex.getMessage(), errorType);
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}
         /**
	 * @param StatusQueryRequest
	 * @return returns gov.va.nvap.privacy.StatusQueryResponseType
	 * @throws ConsentManagementServiceFaultMessage
	 */
	@WebMethod(operationName = "GetStatus")
	@WebResult(name = "StatusQueryResponse", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "StatusQueryResponse")
	public StatusQueryResponse getStatus(
			@WebParam(name = "StatusQueryRequest", targetNamespace = "http://gov.va.nvap.service.privacy/", partName = "StatusQueryRequest") final StatusQueryRequest statusQueryRequest)
			throws ConsentManagementServiceFaultMessage {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try {
            sa = auth.checkAuth(context, applicationContext, "getStatus");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }
        
		long startTime = System.currentTimeMillis();
        
        try {
			return this.consentManagementService.getStatus(statusQueryRequest);
		} catch (final ConsentManagementServiceException ex) {
			final ConsentManagementServiceFaultType errorType = new ConsentManagementServiceFaultType();
            success = 0;
			throw new ConsentManagementServiceFaultMessage(ex.getMessage(), errorType);
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}

    @Override
    @SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    @WebMethod(exclude = true)//internal only
    public ConsentDirectiveRevocationResponse processOldConsentDirectiveRevocation(ConsentDirectiveRevocationRequest consentDirectiveRevocationRequest, Object oldConsent) throws ConsentManagementServiceException {
        return this.consentManagementService.processOldConsentDirectiveRevocation(consentDirectiveRevocationRequest, oldConsent);
    }

    @WebMethod(exclude = true)//internal only
    private String translatePatientIdentifier(String identifier) {
        String identifierToUse = "";

//        if (identifier != null && identifier.length() == 10) {
//            identifierToUse = this.mviSoapEndpoint.findICN(identifier);
//        } else {
            identifierToUse = identifier;
//        }

        return identifierToUse;
    }
    
}
