package gov.va.nvap.server.service.permission.sls.simulator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Class to Parse the XML Document
 * @author Sricharan Reddy *
 */
public class XmlParseUtil
{

	public static final String PATIENT_ID_XPATH = "/ClinicalDocument/recordTarget/patientRole/id/@extension";
	
	/**
	 * Function to parse the XML Document
	 * @param   xmlArray the Byte array representing the XML Document
	 * @return  The string object representing the Patient ID from the Document 
	 */
	public static String parse(byte[] xmlArray)
	{
	 String id = null;
	  try 
		{
		  DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		  ByteArrayInputStream byteStream = new ByteArrayInputStream(xmlArray);
          InputSource is = new InputSource(byteStream);
		  Document doc = db.parse(is);
		  doc.getDocumentElement().normalize();
		  XPathFactory xpf = XPathFactory.newInstance();
	      XPath xpath = xpf.newXPath();
	      id = (String) xpath.evaluate(PATIENT_ID_XPATH, doc, XPathConstants.STRING);
         }
	     catch (XPathExpressionException | ParserConfigurationException | IOException |SAXException e)
		 {
			throw new RuntimeException(e);
		 }
	  
		 return id!=null?id:"";
	 }
	
}
