package gov.va.nvap.server.service.permission.sls.simulator;

import javax.ejb.Stateless;
import javax.jws.WebService;
import javax.xml.ws.soap.MTOM;
import gov.va.nvap.server.service.permission.sls.SecurityLabelingService;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;


/**
 * Web Service Implementation to Mock the Security Labeling Service
 *   
 * @author Sricharan Reddy
 *
 */
@WebService(
    endpointInterface = "gov.va.nvap.server.service.permission.sls.SecurityLabelingService",
    serviceName="SecurityLabelingService",
    portName="SecurityLabelingServicePort",
    targetNamespace = "http://sls.permission.service.server.nvap.va.gov/")
@Stateless
@MTOM
public class SLSMockImpl implements SecurityLabelingService
{
    private static final org.slf4j.Logger LOGGER =
        LoggerFactory.getLogger(SLSMockImpl.class); 
	
    // EJBs are thread-safe
    private RestrictionCheckUtil restrictionUtil;    
    

	@PostConstruct
    public void postConstruct()
    {
        try
        {
           restrictionUtil = RestrictionCheckUtil.create();
        }
        catch(Exception ex)
        {
            LOGGER.warn("Unable to load mock restricted patient ID data from prop file.", ex);
        }
    }

	@Override
	public String evalConfidentialityCode(byte[] ccdXML)
	{
	   String patientID = XmlParseUtil.parse(ccdXML);		
        if(StringUtils.isBlank(patientID))
        {
            throw new IllegalArgumentException("Unable to parse patient ID from given C-CDA CCD.");
        }
		String confidentialityCode = restrictionUtil.checkRestriction(patientID);	
		return confidentialityCode;		
	}
	
	
}
