package gov.va.nvap.server.service.permission.sls.simulator;

import gov.va.nvap.svc.consenteval.common.XACMLContextConstants;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

import org.slf4j.LoggerFactory;

/**
 * Utility to check the Restricted Patients in Database
 *
 * @author Sricharan Reddy
 *
 */

public class RestrictionCheckUtil
{
    private List<String> restrictedList;
    
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(RestrictionCheckUtil.class); 
    
    private static final String propFileSystemProperty  = "vap.sls.simulator.config";
    
    private static final String defaultPropFilePath = "config/vap/slsSimulator.properties";
    
    private static final String propertyName = "sls.restrictedPatients";

    
    
   

	/**
     * Helper function for creating the instance of Restriction Check Util
     * 
     */
    public static RestrictionCheckUtil create() 
    {
        RestrictionCheckUtil rcu = new RestrictionCheckUtil();
        rcu.populateRestrictedList();
        return rcu;
    }

    private RestrictionCheckUtil()
    {
        // hidden constructor
    }

    /**
     * Function to Populate the List of Restricted Patients from Config File
     * 
    */
    private void populateRestrictedList() 
    {
    	Properties  prop   = new Properties();
    	InputStream stream = null;
        String restrictedPatients="";
    	try{
          if(System.getProperty(propFileSystemProperty)!=null)
    	  {
    		 File   file = new File(System.getProperty(propFileSystemProperty));
			 stream = new FileInputStream(file);
		  }
    	  else
    	  {
    		 File   file = new File(defaultPropFilePath);
    		 stream = new FileInputStream(file);
    	  }
    	}catch(FileNotFoundException e)
    	{
    		LOGGER.warn("The properties file is not found ");
    	}
    	try{
    	  if(stream!=null)
    	  {
    	    prop.load(stream);
    	    restrictedPatients = (prop.getProperty(propertyName))!=null?prop.getProperty(propertyName):null;
    	    restrictedList     = (!restrictedPatients.isEmpty())? Arrays.asList(restrictedPatients.split(",")):null;
          }
    	  else
    	  {
    		LOGGER.warn("the property file for loading the properties for SLS Mock is not found ");
    	  }
    	}catch(IOException e)
    	{
    		LOGGER.warn("Error reading properties file for SLS Mock");
    	}       
    }


    /**
     * Function to Check if patient ID is in the restricted list
     *
     * @param patientID ID of the patient
     * @return String representing whether patient is Normal or Not
     */
    public String checkRestriction(String patientID)
    {
        if(restrictedList == null)
        {
            LOGGER.warn("Mock SLS did not find MOCK.SLS.RESTRICTED property key in Property Files; defaulting to NORMAL.");
            return XACMLContextConstants.RESOURCE_CONF_CODE_VAL_NORMAL;
        }
        else if(restrictedList.contains(patientID))
        {
            return XACMLContextConstants.RESOURCE_CONF_CODE_VAL_RESTRICTED;
        }
        else
        {
            return XACMLContextConstants.RESOURCE_CONF_CODE_VAL_NORMAL;
        }
    }
  
    
 
}
