/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.server.service.permission.pdp;

import gov.va.nvap.server.auth.ServiceAuthentication;
import gov.va.nvap.service.auth.ServiceAudit;
import gov.va.nvap.service.auth.ServiceAuthenticationException;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.WebServiceContext;
import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 * 
 * @author Anand Sastry
 * @SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
 * @WebService(serviceName = "PDPWebService", portName = "PDPWebServicePort",
 *                         name = "PDPWebServicePortType", wsdlLocation =
 *                         "META-INF/xml-resources/web-services/PDPWebService/wsdl/XACMLContextHandlerService.wsdl"
 *                         )
 */
@Stateless
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
@WebService(wsdlLocation = "META-INF/xml-resources/web-services/PDP/wsdl/PDPImplWS.wsdl")
// @WebService(serviceName = "PDPWebService",portName = "PDPWebServicePort",
// targetNamespace="urn:oasis:names:tc:xacml:2.0:context:schema:os",
// wsdlLocation =
// "META-INF/xml-resources/web-services/PDPWebService/wsdl/PDPWebService.wsdl")
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class PDPImplWS {

	private static final Logger logger = Logger.getLogger(PDPImplWS.class
			.getName());

	@Autowired
	@Qualifier(value = "PDPImplementation")
	private PDPImplJava simplePDP;// = new PDPImplJava();
        @Autowired
        private ApplicationContext applicationContext;
        @Resource
        private WebServiceContext context;
        private ServiceAuthentication auth = new ServiceAuthentication();
	/**
	 * @param request
	 * @return
	 */
	@WebMethod
	@WebResult(targetNamespace = "urn:oasis:names:tc:xacml:2.0:context:schema:os", name = "Response")
	public ResponseType checkPolicy(final RequestType request) {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try{
            sa = auth.checkAuth(context, applicationContext, "checkPolicy");
        }catch (ServiceAuthenticationException ex) {
            return null;
        }
        
		ResponseType response = null;
        long startTime = System.currentTimeMillis();
        
        try {
            response = null;
            PDPImplWS.logger.entering(this.getClass().getName(), "checkPolicy");
            response = this.simplePDP.checkPolicy(request);
            PDPImplWS.logger.exiting(this.getClass().getName(), "checkPolicy");
        } catch (Exception e) {
            success = 0;
        } finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
        
		return response;
	}
}
