/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.server.service.permission.pdp;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.server.service.permission.common.PatientIdUtil;
import gov.va.nvap.server.service.permission.common.XACMLContextConstants;
import gov.va.nvap.server.service.permission.common.XACMLContextUtil;
import gov.va.nvap.server.service.permission.common.XACMLRequestParser;
import gov.va.nvap.service.permission.pdp.PDPInterface;

import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import oasis.names.tc.xacml._2_0.context.schema.os.DecisionType;
import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResultType;

/**
 * 
 * @author Anand Sastry
 */
public class PDPImplJava implements PDPInterface {

	private static final Logger logger = Logger.getLogger(PDPImplJava.class
			.getName());

	// Values Injected by Spring
	private String localHomeCommunityId;// = "urn:oid:2.16.840.1.113883.4.349";
	private String[] noOptInRequiredHomeCommunities;// =
													// {"urn:oid:2.16.840.1.113883.3.42.10001.100001.12"};
	private String[] patientPurposeForUse;// = {"TREATMENT","EMERGENCY"};
	private boolean validatePatientIdFormat;

	/**
	 * Check the XACML attributes of the incoming request to determine whether
	 * the operation is allowable or not.
	 * 
	 * @param requestType
	 * @return
	 */
	@Override
	public ResponseType checkPolicy(final RequestType requestType) {
		this.info("checkPolicy", "SimplePDP Evaluation Begins ...");

		boolean authorized = false;

		if (XACMLRequestParser.isOutbound(requestType)) {
			authorized = this.checkPolicyOutbound(requestType);
		} else if (XACMLRequestParser.isInbound(requestType)) {
			authorized = this.checkPolicyInbound(requestType);
		}
		/*
		 * This should not make it here in this iteration of VAP1.0 Being
		 * Handled By the Context Handler.
		 * 
		 * 
		 * else if (XACMLRequestParser.isNHINOut(requestType)) { authorized =
		 * checkPolicyNHINOut(requestType); }
		 */
		else {
			authorized = false;
		}
		this.info("checkPolicy", "SimplePDP Evaluation ended.");
		final ResponseType response = this.generateResponse(authorized);
		PDPImplJava.logger.exiting(this.getClass().getName(), "checkPolicy",
				response.getResult().get(0).getDecision());
		return response;
	}

	private boolean checkPolicyInbound(final RequestType requestType) {
		final String requestorsHomeCommunityId = this
				.getRequestorsHomeCommunityId(requestType);

		final String requestorsPurposeForUse = this
				.getPurposeOfUse(requestType);
		final String requestedPatientId = this.getPatientId(requestType);
		final String requestedAction = this.getAction(requestType);

		this.info("checkPolicyInbound",
				"RequestType.requestorsHomeCommunityId=["
						+ requestorsHomeCommunityId + "]");
		this.info("checkPolicyInbound", "RequestType.requestorsPurposeForUse=["
				+ requestorsPurposeForUse + "]");
		this.info("checkPolicyOutbound", "requestedAction=[" + requestedAction
				+ "]");

		// II remotePatientId = getRemotePatientId(requestType);
		// II remotePatientId =
		// extractValueFromResource(requestType.getResource().get(0),
		// RESOURCE_UNIQUE_PATIENT_ID, II.class);
		// requested HCID id VA or allowed home communities

		// checkInboundPolicy ORIGINAL RULE SET
		// HCID is non null
		// POU is non null
		// PID is in a valid ICN format
		// HCID corresponds to DVA's HCID OR in the list of allowed HCIDs
		// Patient is in the MPI
		// requested POU matches patient specified POU
		// Either OptIn is not required or patient has opted in
		// If Transaction is PD, no op. But if it is DQ/DR, correlations are
		// evaluated.

		/*
		 * return !NullChecker.isNullOrEmpty(requestorsHomeCommunityId) &&
		 * !NullChecker.isNullOrEmpty(requestorsPurposeForUse) &&
		 * isValidPatientId(requestedPatientId) &&
		 * (requestorsHomeCommunityId.endsWith(getLocalHomeCommunityId()) ||
		 * (valueEndsWithInArray(requestorsHomeCommunityId,
		 * getAllowedHomeCommunities()) && (requestedPatientId =
		 * getPatientFromMPI(requestedPatientId)) != null &&
		 * valueInArray(requestorsPurposeForUse,
		 * getPatientPurposeForUse(requestedPatientId)) &&
		 * (isNoOptInRequiredCommunity(requestorsHomeCommunityId) ||
		 * isPatientOptedIn(requestedPatientId)) &&
		 * (!(requestedAction.equals("DocumentQueryIn") ||
		 * requestedAction.equals("DocumentRetrieveIn")) || (remotePatientId !=
		 * null && isPatientCorrelatedToRequester(requestedPatientId,
		 * requestorsHomeCommunityId, remotePatientId)))));
		 */

		// ------------------------------------------------------------------------------------//
		// checkInboundPolicy VAP 1.0 RULE - TODO - Validate Business rule
		// HCID is non null
		// POU is non null
		// PID is in a valid ICN format
		// HCID corresponds to DVA's HCID
		// OR
		// HCID is in the list of allowed HCIDs
		// NOT DOING THIS IN VAP 1.0 - Patient is in the MPI
		// requested POU matches patient specified POU
		// Either OptIn is not required or patient has opted in
		// NOT DOING THIS IN VAP 1.0 - If Transaction is PD, no op. But if it is
		// DQ/DR, correlations are evaluated.
		return !NullChecker.isNullOrEmpty(requestorsHomeCommunityId)
				&& !NullChecker.isNullOrEmpty(requestorsPurposeForUse)
				&& this.isValidPatientId(requestedPatientId)
				&& (this.isHomeCommunityLocal(requestorsHomeCommunityId) || (this
						.isHomeCommunityAllowedByPatient(
								requestorsHomeCommunityId, requestType)
						&& this.isRequestorsPOUAllowed(requestorsPurposeForUse) && (this
						.isNoOptInRequiredCommunity(requestorsHomeCommunityId) || this
						.isPatientOptedIn(requestType))));
	}

	private boolean checkPolicyOutbound(final RequestType requestType) {
		final String resourceHomeCommunityId = this
				.getResourceHomeCommunityId(requestType);

		final String requestorsPurposeForUse = this
				.getPurposeOfUse(requestType);
		final String requestedPatientId = this.getPatientId(requestType);
		final String requestedAction = this.getAction(requestType);

		this.info("checkPolicyOutbound",
				"RequestType.resourceHomeCommunityId=["
						+ resourceHomeCommunityId + "]");
		this.info("checkPolicyOutbound",
				"RequestType.requestorsPurposeForUse=["
						+ requestorsPurposeForUse + "]");
		this.info("checkPolicyOutbound", "requestedAction=[" + requestedAction
				+ "]");

		// checkOutboundPolicy ORIGINAL RULE SET
		// HCID is non null
		// POU is non null
		// Requestor's HCID corresponds to DVA for DocQuery and Doc Retrieve.
		// For PD, requestor's HCID should be in allowed hcids
		// If action is DocQuery/DocRetrieve we are done
		// or else if action is PD
		// Validate that Patient id has the correct format
		// Validate that the patient is in the MPI
		// Validate that the requested pou matches patient specific pou
		// Validate if either opt-in is required or if the patient has opted in.
		/*
		 * return !NullChecker.isNullOrEmpty(requestorsHomeCommunityId) &&
		 * !NullChecker.isNullOrEmpty(requestorsPurposeForUse) &&
		 * (resourceHomeCommunityId.endsWith(getLocalHomeCommunityId()) &&
		 * !requestedAction.equals("PatientDiscoveryOut") ||
		 * (valueEndsWithInArray(resourceHomeCommunityId,
		 * getAllowedHomeCommunities()) &&
		 * (requestedAction.equals("DocumentQueryOut") ||
		 * requestedAction.equals("DocumentRetrieveOut") ||
		 * (isValidPatientId(requestedPatientId) && (requestedPatientId =
		 * getPatientFromMPI(requestedPatientId)) != null &&
		 * valueInArray(requestorsPurposeForUse,
		 * getPatientPurposeForUse(requestedPatientId)) &&
		 * (isNoOptInRequiredCommunity(resourceHomeCommunityId) ||
		 * isPatientOptedIn(requestedPatientId))))));
		 */

		// ------------------------------------------------------------------------------------//
		// checkOutboundPolicy VAP 1.0 rule
		// Validate Business rule
		// HCID is non null
		// POU is non null
		// Resource HCID corresponds to DVA for DocQuery and Doc Retrieve. For
		// PD, requestor's HCID should be in allowed hcids
		// If action is DocQuery/DocRetrieve we are done
		// or else if action is PD
		// Validate that Patient id has the correct format
		// NOT DOING THIS IN VAP 1.0 - Validate that the patient is in the MPI
		// Validate that the requested pou matches patient specific pou
		// Validate if either opt-in is required or if the patient has opted in.
		return !NullChecker.isNullOrEmpty(resourceHomeCommunityId)
				&& !NullChecker.isNullOrEmpty(requestorsPurposeForUse)
				&& ((this.isHomeCommunityLocal(resourceHomeCommunityId) && !requestedAction
						.equals(XACMLContextConstants.XACML_REQUEST_PATIENT_DISCOVERY_OUT_ACTION_ID_VALUE))

				|| (requestedAction
						.equals(XACMLContextConstants.XACML_REQUEST_DOC_RETRIEVE_OUT_ACTION_ID_VALUE) || (this
						.isHomeCommunityAllowedByPatient(
								resourceHomeCommunityId, requestType) && (requestedAction
						.equals(XACMLContextConstants.XACML_REQUEST_DOC_QUERY_OUT_ACTION_ID_VALUE)
				// ||
				// requestedAction.equals(XACMLContextConstants.XACML_REQUEST_DOC_RETRIEVE_OUT_ACTION_ID_VALUE)
				|| (this.isValidPatientId(requestedPatientId)
						&& this.isRequestorsPOUAllowed(requestorsPurposeForUse) && (this
						.isNoOptInRequiredCommunity(resourceHomeCommunityId) || this
						.isPatientOptedIn(requestType)))))));
	}

	// -----------------------------------------------------------------
	// Private
	// -----------------------------------------------------------------
	private ResponseType generateResponse(final boolean authorized) {
		final ResponseType response = new ResponseType();
		final List<ResultType> results = response.getResult();
		final ResultType result = new ResultType();
		result.setDecision(authorized ? DecisionType.PERMIT : DecisionType.DENY);
		results.add(result);
		return response;
	}

	private String getAction(final RequestType requestType) {
		// return XACMLRequestParser.getRequestedAction(requestType);
		return XACMLRequestParser.getResourceServiceType(requestType);
	}

	// Data retrieval util
	private String[] getAllowedVistAFacilities(final RequestType requestType) {
		/*
		 * VAP Tracks allowed vista facilities, but does not pass it in the
		 * request. IN the future the PDP can track this. For now, we will have
		 * to move this check to VAP.
		 * 
		 * String allowedVistAFacilities =
		 * propertyLookup.getProperty("AllowedVistAFacilities"); return
		 * !NullChecker.isNullOrEmpty(allowedVistAFacilities) ?
		 * allowedVistAFacilities.split(",") : new String[]{};
		 */
		// VAP 1.0 mechanism, albeit temporary, I think !!!
		final List<String> allowedVISTAFacilities = XACMLContextUtil
				.getResourceAttributeValues(
						requestType,
						XACMLContextConstants.RESOURCE_ALLOWED_VISTA_FACILITIES_ATTR_ID);
		return allowedVISTAFacilities.toArray(new String[allowedVISTAFacilities
				.size()]);
	}

	/**
	 * @return
	 */
	public String getLocalHomeCommunityId() {
		return this.localHomeCommunityId.trim();
	}

	/**
	 * @return
	 */
	public String[] getNoOptInRequiredHomeCommunities() {
		return this.noOptInRequiredHomeCommunities;
		// return new String[] {"2.16.840.1.113883.3.42.10001.100001.12" };
		// //DOD
	}

	private String[] getPatientAllowedHomeCommunities(final RequestType request) {
		final List<String> patientAllowedOrgs = XACMLRequestParser
				.getPatientAllowedHomeCommunities(request);
		return patientAllowedOrgs
				.toArray(new String[patientAllowedOrgs.size()]);
	}

	private String getPatientId(final RequestType requestType) {
		return XACMLRequestParser.getRequestedResourceId(requestType);
	}

	/**
	 * @return
	 */
	public String[] getPatientPurposeForUse() {
		return this.patientPurposeForUse; // new String[] {"TREATMENT",
											// "EMERGENCY" };
	}

	private String getPurposeOfUse(final RequestType requestType) {
		return XACMLRequestParser.getRequestorPurposeOfUse(requestType);
	}

	private String getRequestorsHomeCommunityId(final RequestType requestType) {
		// return XACMLRequestParser.getRequestorHomeCommunityId(requestType);
		return XACMLRequestParser.getSubjectLocality(requestType);
	}

	private String getResourceHomeCommunityId(final RequestType requestType) {
		// return XACMLRequestParser.getResourceHomeCommunityId(requestType);
		return XACMLRequestParser.getEnvironmentLocality(requestType);
	}

	// Used only for NHINOut
	private String getVistAFacilityName(final RequestType requestType) {
		return XACMLRequestParser.getRequestorSubjectId(requestType);
	}

	private void info(final String methodName, final String message) {
		if (PDPImplJava.logger.isLoggable(Level.INFO)) {
			PDPImplJava.logger.logp(Level.INFO, this.getClass().getName(),
					methodName, message);
		}
	}

	private boolean isHomeCommunityAllowedByPatient(
			final String homeCommunityId, final RequestType requestType) {
		boolean isAllowed = false;
		if (!NullChecker.isNullOrEmpty(homeCommunityId)) {
			isAllowed = this.valueInArray(homeCommunityId,
					this.getPatientAllowedHomeCommunities(requestType));
		}
		this.info(
				"isHomeCommunityAllowedByPatient",
				"Is Requestor/Resource HomeCommunityId["
						+ homeCommunityId
						+ "], an allowed Community, OR, is patient opted-out ? Rule Evaluation["
						+ isAllowed + "]");
		return isAllowed;
	}

	private boolean isHomeCommunityLocal(final String homeCommunityId) {
		boolean isLocalRequest = false;
		if (!NullChecker.isNullOrEmpty(homeCommunityId)) {
			isLocalRequest = homeCommunityId.equals(this
					.getLocalHomeCommunityId());
		}
		this.info("isHomeCommunityLocal",
				"Comparing Requestor/Resource HomeCommunityId["
						+ homeCommunityId + "] with LocalHomeCommunityId["
						+ this.localHomeCommunityId + "]. Rule Evaluation["
						+ isLocalRequest + "]");
		return isLocalRequest;
	}

	private boolean isNoOptInRequiredCommunity(final String homeCommunityId) {
		boolean noOptInRequired = true;
		if (!NullChecker.isNullOrEmpty(homeCommunityId)) {
			noOptInRequired = this.valueEndsWithInArray(homeCommunityId,
					this.getNoOptInRequiredHomeCommunities());
		}
		this.info("isNoOptInRequiredCommunity",
				"Is Requestor/Resource HomeCommunityId[" + homeCommunityId
						+ "]'s opt-in required ? [" + !noOptInRequired + "]");
		return noOptInRequired;
	}

	private boolean isPatientOptedIn(final RequestType request) {
		final List<String> optIns = XACMLContextUtil
				.getResourceAttributeValues(request,
						XACMLContextConstants.RESOURCE_OPTIN_ATTR_ID);
		boolean isPatientOptedIn = false;
		if ((optIns != null) && (optIns.size() > 0)) {
			isPatientOptedIn = XACMLContextConstants.RESOURCE_OPTIN_YES_VALUE
					.equals(optIns.get(0));
		}
		this.info("isPatientOptedIn", "Opt-In Status [" + isPatientOptedIn
				+ "]");
		return isPatientOptedIn;
	}

	private boolean isRequestorsPOUAllowed(final String requestorsPurposeOfUse) {
		boolean isAllowedPOU = false;
		if (!NullChecker.isNullOrEmpty(requestorsPurposeOfUse)) {
			isAllowedPOU = this.valueInArray(requestorsPurposeOfUse,
					this.getPatientPurposeForUse());
		}
		this.info("isRequestorsPOUAllowed", "RequestorsPOU["
				+ requestorsPurposeOfUse + "] is allowed [" + isAllowedPOU
				+ "]");
		return isAllowedPOU;
	}

	private boolean isValidPatientId(String patientId) {
		this.info("isValidPatientId", "PatientId [" + patientId + "]");
		if (NullChecker.isNullOrEmpty(patientId)) {
			return false;
		}

		if (!this.validatePatientIdFormat) {
			PDPImplJava.logger.warning("PatientId Format Validation Disabled");
			return true; // Patient Validation is off
		}

		final String ICN_PATTERN = "^\\d{10}(V\\d{6})?$";
		boolean ret = false;

		patientId = PatientIdUtil.parsePatientIdFromHL7CXType(patientId);

		if (!NullChecker.isNullOrEmpty(patientId)
				&& Pattern.matches(ICN_PATTERN, patientId)) {
			ret = true;
		} else {
			PDPImplJava.logger.warning("patientId (" + patientId
					+ ") is not a valid ICN.");
		}

		return ret;
	}

	/**
	 * @param localHomeCommunityId
	 */
	public void setLocalHomeCommunityId(final String localHomeCommunityId) {
		this.localHomeCommunityId = localHomeCommunityId;
	}

	/*
	 * private Object getRemotePatientId(final RequestType requestType) {
	 * List<Object> objs =
	 * XACMLContextUtil.getResourceAttributeObjects(requestType,
	 * XACMLContextConstants.XACML_REQUEST_RESOURCE_SUBJECT_ID_ATTR_ID); if
	 * (objs == null || objs.size() == 0) { return null; } return objs.get(0); }
	 */

	/**
	 * @param noOptInRequiredHomeCommunities
	 */
	public void setNoOptInRequiredHomeCommunities(
			final String[] noOptInRequiredHomeCommunities) {
		this.noOptInRequiredHomeCommunities = noOptInRequiredHomeCommunities;
	}

	// Logging utility methods. - Refactor and relocate or use AOP

	/**
	 * @param patientPurposeOfUse
	 */
	public void setPatientPurposeOfUse(final String[] patientPurposeOfUse) {
		this.patientPurposeForUse = patientPurposeOfUse;
	}

	private boolean valueEndsWithInArray(final String value,
			final String[] array) {
		boolean ret = false;
		final String toUpperValue = value.toUpperCase(Locale.ENGLISH).trim();

		for (final String s : array) {
			ret = (s.trim().equals("*") || toUpperValue.endsWith(s.trim()
					.toUpperCase(Locale.ENGLISH)));
			if (ret) {
				break;
			}
		}

		return ret;
	}

	// Utility methods
	private boolean valueInArray(final String value, final String[] array) {
		boolean ret = false;

		for (final String s : array) {
			ret = (s.trim().equals("*") || s.trim().equalsIgnoreCase(
					value.trim()));
			if (ret) {
				break;
			}
		}

		return ret;
	}

	private boolean valueStartsWithInArray(final String value,
			final String[] array) {
		boolean ret = false;
		final String toUpperValue = value.toUpperCase().trim();

		for (final String s : array) {
			ret = (s.trim().equals("*") || toUpperValue.startsWith(s.trim()
					.toUpperCase(Locale.ENGLISH)));
			if (ret) {
				break;
			}
		}

		return ret;
	}

	// --------------------------------------------
	// OLD Artifacts - Delete
	/*
	 * private boolean isPatientOptedIn(String patientId) { // Original
	 * Implementation Patient patient =
	 * patientManager.getPatientByICN(patientId); return patient != null &&
	 * patient.getExpiration().after(new Date()); }
	 * 
	 * private boolean isPatientCorrelatedToRequester(String patientId, String
	 * homeCommunityId, Object remotePatientId) { boolean ret = false;
	 * 
	 * Facility facility =
	 * facilityManager.getFacilityByHomeCommunityId(stripDecorations
	 * (homeCommunityId)); if (facility != null) { DataQuery dataQuery =
	 * getDataManager().getQuery("MPI.findNHINCorrelations");
	 * dataQuery.setParameter("icn", patientId);
	 * dataQuery.setParameter("correlatedFacilityNumber",
	 * facility.getFacilityNumber()); List<Map> results =
	 * dataQuery.getResults(); for (Map result : results) { String
	 * correlatedPatientId = (String)result.get("correlatedPatientId"); String
	 * correlatedAssigningAuthority =
	 * (String)result.get("correlatedAssigningAuthority"); if
	 * (correlatedAssigningAuthority.equals(remotePatientId.getRoot()) &&
	 * correlatedPatientId.equals(remotePatientId.getExtension())) { ret = true;
	 * break; } } } else { ret = false; }
	 * 
	 * return ret; }
	 * 
	 * private String stripDecorations(String homeCommunityId) { String ret;
	 * 
	 * if (homeCommunityId.startsWith("urn:oid:")) { ret =
	 * homeCommunityId.substring(8); } else { ret = homeCommunityId; }
	 * 
	 * return ret; }
	 * 
	 * private String getPatientFromMPI(String patientId) { String ret = null;
	 * DataQuery dataQuery = getDataManager().getQuery("MPI.findDemographics");
	 * dataQuery.setParameter("icn",
	 * PatientIdFormatUtil.parsePatientId(patientId)); List<Map> results =
	 * dataQuery.getResults(); if (!NullChecker.isNullOrEmpty(results)) { String
	 * pid = (String)results.get(0).get("MRN"); if (!patientId.startsWith(pid))
	 * { logger.severe("Input patientId (" + patientId +
	 * ") does not match MPI patientId (" + pid + ").  Check configuration."); }
	 * else { ret = pid; } } else { logger.warning("patientId (" + patientId +
	 * ") is not in the MPI."); }
	 * 
	 * return ret; }
	 * 
	 * 
	 * private DataManager getDataManager() { return
	 * DataManagerFactory.getDataManager
	 * (propertyLookup.getProperty("dataManagerConfigFilename")); }
	 */
}
