/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.server.service.permission.contexthandler;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.server.auth.ServiceAuthentication;
import gov.va.nvap.server.endpoint.psim.PersonServiceInterface;
import gov.va.nvap.server.service.permission.common.PatientIdUtil;
import gov.va.nvap.server.service.permission.common.XACMLContextConstants;
import gov.va.nvap.server.service.permission.common.XACMLContextUtil;
import gov.va.nvap.server.service.permission.common.XACMLMessageMarshaller;
import gov.va.nvap.server.service.permission.common.XACMLRequestParser;
import gov.va.nvap.service.auth.ServiceAudit;
import gov.va.nvap.service.auth.ServiceAuthenticationException;
import gov.va.nvap.service.pdq.PatientCorrelationsQuery;
import gov.va.nvap.service.pdq.PatientCorrelationsResponse;
import gov.va.nvap.service.pdq.PdqException;
import gov.va.nvap.service.pdq.PdqService;
import gov.va.nvap.service.permission.pdp.PDPInterface;
import gov.va.nvap.svc.consentmgmt.PIPInterface;
import gov.va.nvap.svc.consentmgmt.PolicyConstraints;
import gov.va.nvap.svc.consentmgmt.stub.data.Facility;
import gov.va.nvap.svc.consentmgmt.stub.data.Organization;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.WebServiceContext;
import oasis.names.tc.xacml._2_0.context.schema.os.DecisionType;
import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResultType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 *
 * @author Anand Sastry
 */
@Stateless(name = "XACMLContextHandlerService1", mappedName = "XACMLContextHandlerService1")
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
@WebService(serviceName = "XACMLContextHandlerService1",
            portName = "XACMLContextHandlerPort1",
            name = "XACMLContextHandlerPortType1"/*,
            wsdlLocation = "META-INF/xml-resources/web-services/XACMLContextHandlerService/wsdl/XACMLContextHandlerService.wsdl"*/)
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class XACMLContextHandlerService
{
    private static final Logger logger = Logger
            .getLogger(XACMLContextHandlerService.class.getName());

    // @Autowired
    // @Value("${dod.homeCommunityOidExt}")
    private final String dodHomeCommunityId = "urn:oid:2.16.840.1.113883.3.42.10001.100001.12";
    // private String dodHomeCommunityNumber = "200DOD";

    // Values Injected by Spring
    // @Autowired
    // @Value("${va.homeCommunityOidExt}")
    private final String localHomeCommunityId = "urn:oid:2.16.840.1.113883.4.349";

    @Autowired
    @Qualifier(value = "pdpServiceEndpoint")
    private PDPInterface pdpProxy; // = new PDPImplJava();

    @Autowired
    @Qualifier(value = "PdqService")
    private PdqService pdqService;

    @Autowired
    @Qualifier(value = "personService")
    private PersonServiceInterface personService;
    @EJB(name = "PipService", beanInterface = PIPInterface.class)
    private PIPInterface pip;

    @Autowired
    private ApplicationContext applicationContext;
    @Resource
    private WebServiceContext context;
    private ServiceAuthentication auth = new ServiceAuthentication();
	private String addOidPrefix(final String value) {
        if (value.startsWith("urn:oid:")) {
            return value;
        }
        return "urn:oid:" + value;
    }

    private boolean checkOptedInIfPertinent(final String optInStatus,
			final String hcid) {
        return (XACMLContextConstants.RESOURCE_OPTIN_YES_VALUE
                .equals(optInStatus) || this.dodHomeCommunityId.equals(hcid));
    }

    /**
     * @param request
     * @return
     */
    @WebMethod
	public ResponseType checkPolicy(final RequestType request) {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;

        try {
            sa = auth.checkAuth(context, applicationContext, "checkPolicy");
        }catch (ServiceAuthenticationException ex) {
            return null;
        }
        ResponseType response = null;
        long startTime = System.currentTimeMillis();

        try {
            XACMLContextHandlerService.logger.entering(this.getClass().getName(),
                    "checkPolicy");
            this.dumpRequestContents("In CheckPolicy - Received from Adapter", request);
            this.info("checkPolicy", "XACMLContextHandler Processing Begins ...");

            if (XACMLRequestParser.isNHINOut(request)) {
                response = this.evaluateForNHINOut(request);
            } else {
                response = this.evaluateNwHINTransactions(request);
            }
            this.info("checkPolicy", "XACMLContextHandler Processing Ended.");
            XACMLContextHandlerService.logger.exiting(this.getClass().getName(), "checkPolicy", response.getResult().get(0).getDecision());
        } catch (Exception e) {
            success = 0;
        } finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }

        return response;
    }

	private void dumpRequestContents(final String context, final RequestType req) {
        if (XACMLContextHandlerService.logger.isLoggable(Level.INFO)) {
            final StringWriter sw = new StringWriter();
            // FileWriter fw = new FileWriter();
            XACMLMessageMarshaller
                    .marshalXACMLRequestToWriter(context, req, sw);
            XACMLContextHandlerService.logger.logp(Level.INFO,
                    "XACMLContextHandlerService", context, sw.getBuffer()
                            .toString());
            try {
                sw.close();
			} catch (final IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

    }

    private void dumpResponseContents(final String context,
			final ResponseType res) {
        if (XACMLContextHandlerService.logger.isLoggable(Level.INFO)) {
            final StringWriter sw = new StringWriter();
            // FileWriter fw = new FileWriter();
            XACMLMessageMarshaller.marshalXACMLResponseToWriter(context, res,
                    sw);
            XACMLContextHandlerService.logger.logp(Level.INFO,
                    "XACMLContextHandlerService", context, sw.getBuffer()
                            .toString());
            try {
                sw.close();
			} catch (final IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

	private ResponseType evaluateForNHINOut(final RequestType requestType) {
        final String userId = this.getSubjectId(requestType);
        final boolean authorized = !NullChecker.isNullOrEmpty(userId)
                && this.valueStartsWithInArray(userId,
                        this.getVistAFacilities());
        final ResponseType resType = this.generateResponse(authorized);
        this.dumpResponseContents("Response from Within XACMLContextHandler ",
                resType);
        return resType;
    }

	private ResponseType evaluateNwHINTransactions(final RequestType request) {
        // try {
        try {
            this.loadConstraintsFromPIP(request);
		} catch (final Exception e) {
            this.info("evaluateNwHINTransactions",
                    "Exception - " + e.getMessage()
                    + ". Not delegating to PDP. ");
            final ResponseType resType = this.generateResponse(false);
            this.dumpResponseContents(
                    "Response from Within XACMLContextHandler ", resType);
            return resType;
        }
        this.transformAttributes(request);
        // } catch (Throwable e) {
        // System.out
        // .println("XACMLContextHandlerService:evaluateNwHINTransactions - Exception - "
        // + e.getLocalizedMessage());
        // Should we let the evaluation to PDP play it out ????
        // Or should we force a DENY ??
        // Play it out for now ...
        // }

        this.dumpRequestContents(
                "In evaluateNwHINTransactions - After data has been loaded from the PIP. Payload to PDP ...",
                request);
        return this.evaluateRequestAgainstPDPPolicy(request);
    }

    private ResponseType evaluateRequestAgainstPDPPolicy(
			final RequestType request) {
        XACMLContextHandlerService.logger.entering(this.getClass().getName(),
                "evaluateRequestAgainstPDPPolicy");
        final ResponseType resType = this.pdpProxy.checkPolicy(request);
        this.dumpResponseContents("Response from PDP ", resType);
        XACMLContextHandlerService.logger.exiting(this.getClass().getName(),
                "evaluateRequestAgainstPDPPolicy");
        return resType;
    }

	private ResponseType generateResponse(final boolean authorized) {
        final ResponseType response = new ResponseType();
        final List<ResultType> results = response.getResult();
        final ResultType result = new ResultType();
        result.setDecision(authorized ? DecisionType.PERMIT : DecisionType.DENY);
        results.add(result);
        return response;
    }

    // The only reason NHINOut processing is being done here is that Allowed
    // VistA Facilities are being
    // maintained by VAP. It should not be. It should be directly available to
    // PDP. The only way it makes
    // sense for VAP to maintain it, is if an exclusion is applied for a
    // patient.
    // Everything below this be eliminated. All evaluation, including for
    // NHINOut should happen in the PDP.

	private String getOptInStatus(final PolicyConstraints pc) {
        if (pc == null) {
            return XACMLContextConstants.RESOURCE_OPTIN_VALUE_NO;
        }
        return XACMLContextConstants.RESOURCE_OPTIN_YES_VALUE;
    }

	private Map<String, String> getPatientAllowedOrganizationOidsAndNumbers() {

        /*
		 * Map<String, String> patientAllowedOrganizationOidsAndNumbers = new
		 * HashMap<String, String>(); if (pc == null) { //DOD is always allowed
		 * patientAllowedOrganizationOidsAndNumbers.put(dodHomeCommunityId,
		 * dodHomeCommunityNumber); return
		 * patientAllowedOrganizationOidsAndNumbers; }
		 * 
		 * Iterator<Organization> allowedOrganizationsIt = pip
		 * .getAllowedOrganizations().iterator(); Collection<Organization>
		 * patientExcludedOrgs = pc .getPatientExcludedOrganizations();
		 * 
		 * while (allowedOrganizationsIt.hasNext()) { Organization allowedOrg =
		 * allowedOrganizationsIt.next(); if
		 * (!patientExcludedOrgs.contains(allowedOrg)) {
		 * patientAllowedOrganizationOidsAndNumbers
		 * .put(addOidPrefix(allowedOrg.getOrgOid()),
		 * allowedOrg.getOrgNumber()); }
		 * 
		 * }
		 * 
		 * return patientAllowedOrganizationOidsAndNumbers;
         */

 /* Reevaluate needing this method in I2 */

        final Map<String, String> patientAllowedOrganizationOidsAndNumbers = new HashMap<String, String>();
        final Iterator<Organization> allowedOrganizationsIt = this.pip
                .getAllowedOrganizations().iterator();
        while (allowedOrganizationsIt.hasNext()) {
            final Organization allowedOrg = allowedOrganizationsIt.next();
            patientAllowedOrganizationOidsAndNumbers.put(
                    this.addOidPrefix(allowedOrg.getOrgOid()),
                    allowedOrg.getOrgNumber());
        }
        return patientAllowedOrganizationOidsAndNumbers;

    }

    private List<String> getPatientAllowedOrganizations(
			final PolicyConstraints pc) {
        final List<String> patientAllowedOrganizations = new ArrayList<String>();
        if (pc == null) {
            // DOD is always allowed
            patientAllowedOrganizations.add(this.dodHomeCommunityId);
            return patientAllowedOrganizations; // empty list currently
        }

        final Iterator<Organization> allowedOrganizationsIt = pc
                .getAllowedOrganizations().iterator();
        final Collection<Organization> patientExcludedOrgs = pc
                .getPatientExcludedOrganizations();

        while (allowedOrganizationsIt.hasNext()) {
            final Organization allowedOrg = allowedOrganizationsIt.next();
            if (!patientExcludedOrgs.contains(allowedOrg)) {
                patientAllowedOrganizations.add(this.addOidPrefix(allowedOrg
                        .getOrgOid()));
            }

        }

        return patientAllowedOrganizations;

    }

	private String getRequestedPatientId(final RequestType request) {
        return XACMLRequestParser.getRequestedResourceId(request);
    }

    // Used only for NHINOut
	private String getSubjectId(final RequestType requestType) {
        return XACMLRequestParser.getRequestorSubjectId(requestType);
    }

	private List<String> getVistAFacilities() {
        final List<String> VistAFacilities = new ArrayList<String>();

        final Collection<Facility> allowedVistAFacilities = this.pip
                .getAllowedVistAFacilities();

        for (final Facility facility : allowedVistAFacilities) {
            VistAFacilities.add(facility.getFacilityStation());
        }

        return VistAFacilities;

    }

	private void info(final String methodName, final String message) {
        if (XACMLContextHandlerService.logger.isLoggable(Level.INFO)) {
            //XACMLContextHandlerService.logger.logp(Level.INFO, this.getClass()
            //		.getName(), methodName, message);
        }
    }

	private boolean isLocalHomeCommunity(final String requestorHCID) {
        return requestorHCID.contains(this.localHomeCommunityId);
    }

    private boolean isPatientCorrelatedToRequestorsHomeCommunity(
			final String patientId, final String requestorHCID) {
        XACMLContextHandlerService.logger.entering(this.getClass().getName(),
                "isPatientCorrelatedToRequestorsHomeCommunity");

        final String facilityFromRequest = this
                .getPatientAllowedOrganizationOidsAndNumbers().get(
                        requestorHCID);
        String correlatedPatientId = null;

        try {
            final PatientCorrelationsQuery correlationsQuery = new PatientCorrelationsQuery();
            correlationsQuery.setPatientId(patientId);
            final PatientCorrelationsResponse correlationsResponse = this.pdqService
                    .getCorrelatedFacilities(correlationsQuery);
            final List<gov.va.nvap.service.pdq.Facility> facilities = correlationsResponse
                    .getFacilities();
            for (final gov.va.nvap.service.pdq.Facility facility : facilities) {
                final String facilityNumber = facility.getFacilityNumber();
                if (facilityNumber.equals(facilityFromRequest)) {
                    correlatedPatientId = facility.getCorrelatedPatientId();
                    break;
                }
            }
		} catch (final PdqException e) {
            if (XACMLContextHandlerService.logger.isLoggable(Level.FINE)) {
                e.printStackTrace();
            }
            XACMLContextHandlerService.logger.logp(Level.SEVERE, this
                    .getClass().getName(),
                    "isPatientCorrelatedToRequestorsHomeCommunity", e
                            .getMessage());
        }

        this.info("isPatientCorrelatedToRequestorsHomeCommunity",
                "Patient correlation id is  [" + correlatedPatientId + "]");
        XACMLContextHandlerService.logger.exiting(this.getClass().getName(),
                "isPatientCorrelatedToRequestorsHomeCommunity");
        return ((correlatedPatientId != null) && (correlatedPatientId.trim()
                .length() > 0));
    }

    private void loadConstraintsFromPIP(final RequestType request)
			throws Exception {
        XACMLContextHandlerService.logger.entering(this.getClass().getName(),
                "loadConstraintsFromPIP");
        // Obtain Patient IEN from request
        String patientId = this.getRequestedPatientId(request);
        this.info("loadConstraintsFromPIP", "Get IEN from Request ["
                + patientId + "]");

        // Some attribute in RequestType should specify ConsentType
        // Defaulting to NwHIN
        final String consentType = "NwHIN Authorization";

        if (!NullChecker.isNullOrEmpty(patientId)) {
            // Patient ID might be in the HL7V2 CX Format.
            patientId = PatientIdUtil.parsePatientIdFromHL7CXType(patientId);

            //
            // Contact PIP and obtain Constraints
            PolicyConstraints pc = null;
            try {
                pc = this.pip.getPolicyConstraints(
                        this.personService.getCorrelatedIds(patientId),
                        this.pip.getConsentTypeByName(consentType));
                // List<String> vpids = new ArrayList<String>();
                // vpids.add(patientId);
                // pc =
                // pip.getPolicyConstraints(vpids,pip.getConsentTypeByName(consentType));
			} catch (final Exception e) {
                if (XACMLContextHandlerService.logger.isLoggable(Level.FINE)) {
                    e.printStackTrace();
                }
                XACMLContextHandlerService.logger.logp(Level.WARNING, this
                        .getClass().getName(), "loadConstraintsFromPIP", e
                                .getMessage());
            }

            // Evaluate Constraints and set Opt-In information on request
            final String status = this.getOptInStatus(pc);
            XACMLContextUtil.addResourceAttributeValue(
                    XACMLContextConstants.RESOURCE_OPTIN_ATTR_ID,
                    XACMLContextConstants.STRING_ATTR_DATA_TYPE, status,
                    request);

            this.info("loadConstraintsFromPIP",
                    "Setting OPT-IN attribute on request - "
                    + XACMLContextConstants.RESOURCE_OPTIN_ATTR_ID
                    + " " + status);

            // Evaluate Constraints and set patient-allowed list (TODO: For now,
            // could change to patient disallowed list)
            final List<String> patientAllowedOrgs = this
                    .getPatientAllowedOrganizations(pc);
            XACMLContextUtil
                    .addResourceAttributeValues(
                            XACMLContextConstants.RESOURCE_PATIENT_ALLOWED_ORGS_ATTR_ID,
                            XACMLContextConstants.STRING_ATTR_DATA_TYPE,
                            patientAllowedOrgs, request);

            this.info(
                    "loadConstraintsFromPIP",
                    "Setting Patient allowed organizations attribute(s) on request - "
                    + XACMLContextConstants.RESOURCE_PATIENT_ALLOWED_ORGS_ATTR_ID
                    + " " + patientAllowedOrgs);

            // Hack - Should be done by PDP.
            // Being done here as it requires some info from the PIP.
            // This method throws an exception
            this.performPatientCorrelationCheckIfRequired(request, patientId,
                    status);
        }
        XACMLContextHandlerService.logger.exiting(this.getClass().getName(),
                "loadConstraintsFromPIP");
    }

    private void performPatientCorrelationCheckIfRequired(
            final RequestType request, final String patientId,
			final String status) throws Exception {
        final String requestorHCID = this.addOidPrefix(XACMLRequestParser
                .getRequestorHomeCommunityId(request));
        this.info("performPatientCorrelationCheckIfRequired",
                "Get Requestors HCID from Request [" + requestorHCID + "]");

        if (!this.isLocalHomeCommunity(requestorHCID)
                && XACMLRequestParser.isInbound(request)
                && (XACMLRequestParser.isDocQuery(request) || XACMLRequestParser
                .isDocRetrieve(request))
                && this.checkOptedInIfPertinent(status, requestorHCID)) {
            final boolean correlationsExist = this
                    .isPatientCorrelatedToRequestorsHomeCommunity(patientId,
                            requestorHCID);
            if (!correlationsExist) {
                throw new Exception(
                        "performPatientCorrelationCheckIfRequired - No Correlations Exist for patient, "
                        + patientId);
            }
		} else {
            this.info("performPatientCorrelationCheckIfRequired",
                    "Patient Correlation Check not required.");
        }
    }

	private void transformAttributes(final RequestType request) {
        XACMLContextHandlerService.logger.entering(this.getClass().getName(),
                "transformAttributes");
        // 1)Set XSPA Attribute, urn:oasis:names:tc:xacml:2.0:subject:locality"
        // with requestor's Home Community
        final String subjectLocality = this.addOidPrefix(XACMLRequestParser
                .getRequestorHomeCommunityId(request));

        this.info("transformAttributes", "Setting "
                + XACMLContextConstants.SUBJECT_LOCALITY_ATTR_ID + " = "
                + subjectLocality);
        XACMLContextUtil.addSubjectAttributeValue(
                XACMLContextConstants.SUBJECT_LOCALITY_ATTR_ID,
                XACMLContextConstants.STRING_ATTR_DATA_TYPE, subjectLocality,
                request);

        // 2)Set XSPA Attribute,
        // urn:oasis:names:tc:xacml:2.0:environment:locality"
        // with resource Home Community
        final String environmentLocality = this.addOidPrefix(XACMLRequestParser
                .getResourceHomeCommunityId(request));

        this.info("transformAttributes", "Setting "
                + XACMLContextConstants.ENV_LOCALITY_ATTR_ID + " = "
                + environmentLocality);
        XACMLContextUtil.addResourceAttributeValue(
                XACMLContextConstants.ENV_LOCALITY_ATTR_ID,
                XACMLContextConstants.STRING_ATTR_DATA_TYPE,
                environmentLocality, request);

        // 3)Based on action set HL7 Resource type to
        // urn:oasis:names:tc:xspa:1.0:resource:hl7:type:patient-search
        // and
        // urn:oasis:names:tc:xspa:1.0:resource:hl7:type:medical-record
        // Note: This step might not be necessary. Evaluate and remove in VAP
        // 2.0
        if (XACMLRequestParser.isDocQuery(request)
                || XACMLRequestParser.isDocRetrieve(request)) {

            this.info("transformAttributes", "Setting "
                    + XACMLContextConstants.RESOURCE_TYPE_ATTR_ID + " = "
                    + XACMLContextConstants.RESOURCE_TYPE_MEDICAL_RECORD_VALUE);
            XACMLContextUtil.addResourceAttributeValue(
                    XACMLContextConstants.RESOURCE_TYPE_ATTR_ID,
                    XACMLContextConstants.STRING_ATTR_DATA_TYPE,
                    XACMLContextConstants.RESOURCE_TYPE_MEDICAL_RECORD_VALUE,
                    request);
		} else if (XACMLRequestParser.isPatientDiscovery(request)) {

            this.info("transformAttributes", "Setting "
                    + XACMLContextConstants.RESOURCE_TYPE_ATTR_ID + " = "
                    + XACMLContextConstants.RESOURCE_TYPE_PATIENT_SEARCH_VALUE);
            XACMLContextUtil.addResourceAttributeValue(
                    XACMLContextConstants.RESOURCE_TYPE_ATTR_ID,
                    XACMLContextConstants.STRING_ATTR_DATA_TYPE,
                    XACMLContextConstants.RESOURCE_TYPE_PATIENT_SEARCH_VALUE,
                    request);
        }

        // 4 Create ServiceType Attributes with same values as ActionId
        // attributes
        // The new XACML Policies evaluate based on ServiceType Attributes as
        // opposed to the old version which used ActionId attributes
        // We are nor removing ActionId attributes yet, even though they will
        // not be evaluated. We can chose to remove this in the future.

        // Action value might not be needed. Evaluate and delete in VAP 2.0
        final String actionValue = XACMLRequestParser
                .getRequestedAction(request);
        this.info("transformAttributes", "Setting "
                + XACMLContextConstants.RESOURCE_SERVICE_TYPE_ATTR_ID + " = "
                + actionValue);
        XACMLContextUtil.addResourceAttributeValue(
                XACMLContextConstants.RESOURCE_SERVICE_TYPE_ATTR_ID,
                XACMLContextConstants.STRING_ATTR_DATA_TYPE, actionValue,
                request);

        // 5) Ensure that HomeCommunityId attributes have the "urn:oid" prefix
        // Might not have to do this if only subjectLocality is evaluated by PDP
        // REFACTOR

        String requestorHCID = XACMLRequestParser
                .getRequestorHomeCommunityId(request);
        if (!NullChecker.isNullOrEmpty(requestorHCID)
                && !requestorHCID.startsWith("urn:oid:")) {
            this.info("transformAttributes",
                    "Prefixing requestor HCID with urn:oid:");
            requestorHCID = this.addOidPrefix(requestorHCID);
            // remove existing attribute
            XACMLRequestParser.extractRequestorHomeCommunityId(request);
            // add the new attribute
            XACMLContextUtil
                    .addSubjectAttributeValue(
                            XACMLContextConstants.XACML_REQUEST_SUBJECT_HOME_COMMUNITY_ID_ATTR_ID,
                            XACMLContextConstants.STRING_ATTR_DATA_TYPE,
                            requestorHCID, request);
        }

        String resourceHCID = XACMLRequestParser
                .getResourceHomeCommunityId(request);
        if (!NullChecker.isNullOrEmpty(resourceHCID)
                && !resourceHCID.startsWith("urn:oid:")) {
            this.info("transformAttributes",
                    "Prefixing resource HCID with urn:oid:");
            resourceHCID = this.addOidPrefix(resourceHCID);
            // remove existing attribute
            XACMLRequestParser.extractResourceHomeCommunityId(request);
            // add the new attribute
            XACMLContextUtil
                    .addResourceAttributeValue(
                            XACMLContextConstants.XACML_REQUEST_RESOURCE_HOME_COMMUNITY_ID_ATTR_ID,
                            XACMLContextConstants.STRING_ATTR_DATA_TYPE,
                            resourceHCID, request);
        }

        // 6 Add empty environment element
        this.info("transformAttributes", "Adding empty environment element");
        XACMLContextUtil.addEmptyEnvironmentElement(request);

        // 7 Iterate through Subject, Resource and Action attributes. If they
        // are missing
        // data types create data types. If they are missing data type values,
        // default to String
        // Might not be the best solution. Re-evaluate in VAP 2.0
        //
        this.info("transformAttributes",
                "Performing message validation and structural integrity");
        XACMLRequestParser.validateAndFixMessage(request);
        // 8 Replace POU attribute's, data type with String
        // Might not be the best solution. Re-evaluate in VAP 2.0
        //
        this.info("transformAttributes",
                "Performing message validation and structural integrity");
        // remove existing attribute
        final String pou = XACMLRequestParser.extractSubjectPOU(request);
        // add the new attribute
        XACMLContextUtil
                .addSubjectAttributeValue(
                        XACMLContextConstants.XACML_REQUEST_SUBJECT_PURPOSE_FOR_USE_ATTR_ID,
                        XACMLContextConstants.STRING_ATTR_DATA_TYPE, pou,
                        request);

        XACMLContextHandlerService.logger.exiting(this.getClass().getName(),
                "transformAttributes");
    }

    private boolean valueStartsWithInArray(final String value,
			final List<String> array) {
        boolean ret = false;
        final String toUpperValue = value.toUpperCase(Locale.ENGLISH);

        for (final String s : array) {
            ret = (s.equals("*") || toUpperValue.startsWith(s.toUpperCase(Locale.ENGLISH)));
            if (ret) {
                break;
            }
        }

        return ret;
    }

}
