package gov.va.nvap.server.service.permission.common;

import gov.va.nvap.common.validation.NullChecker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import oasis.names.tc.xacml._2_0.context.schema.os.AttributeType;
import oasis.names.tc.xacml._2_0.context.schema.os.AttributeValueType;
import oasis.names.tc.xacml._2_0.context.schema.os.EnvironmentType;
import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResourceType;
import oasis.names.tc.xacml._2_0.context.schema.os.SubjectType;

/**
 * 
 * @author Anand Sastry
 */
public class XACMLContextUtil {

	/**
	 * @param attributeId
	 * @param attributeDataType
	 * @param attributeValue
	 */
	public static void addActionAttributeValue(final String attributeId,
			final String attributeDataType, final String attributeValue) {
	}

	/**
	 * @param request
	 */
	public static void addEmptyEnvironmentElement(final RequestType request) {
		if (!NullChecker.isNullOrEmpty(request)) {
			if (NullChecker.isNullOrEmpty(request.getEnvironment())) {
				final EnvironmentType et = new EnvironmentType();
				request.setEnvironment(et);
			}
		}

	}

	/**
	 * @param attributeId
	 * @param attributeDataType
	 * @param attributeValue
	 * @param request
	 */
	public static void addResourceAttributeValue(final String attributeId,
			final String attributeDataType, final String attributeValue,
			final RequestType request) {
		if (!NullChecker.isNullOrEmpty(attributeId)
				&& !NullChecker.isNullOrEmpty(attributeDataType)
				&& !NullChecker.isNullOrEmpty(attributeValue)
				&& !NullChecker.isNullOrEmpty(request)) {
			final List<String> attributeValues = new ArrayList<String>();
			attributeValues.add(attributeValue);
			XACMLContextUtil.addResourceAttributeValues(attributeId,
					attributeDataType, attributeValues, request);
		}

	}

	/**
	 * @param attributeId
	 * @param attributeDataType
	 * @param attributeValues
	 * @param request
	 */
	public static void addResourceAttributeValues(final String attributeId,
			final String attributeDataType, final List<String> attributeValues,
			final RequestType request) {
		if (!NullChecker.isNullOrEmpty(attributeId)
				&& !NullChecker.isNullOrEmpty(attributeDataType)
				&& (attributeValues != null)
				&& !NullChecker.isNullOrEmpty(request)) {
		}
		ResourceType rt = request.getResource().get(0);
		if (NullChecker.isNullOrEmpty(rt)) {
			rt = new ResourceType();
			request.getResource().add(rt);
		}

		final Iterator<String> attributeValuesIt = attributeValues.iterator();
		while (attributeValuesIt.hasNext()) {
			final String attributeValue = attributeValuesIt.next();
			if ((attributeValue == null)
					|| (attributeValue.trim().length() == 0)) {
				continue;
			}
			rt.getAttribute().add(
					XACMLContextUtil.createAttributeValueType(attributeId,
							attributeDataType, attributeValue.trim()));
		}

	}

	/**
	 * @param attributeId
	 * @param attributeDataType
	 * @param attributeValue
	 * @param request
	 */
	public static void addSubjectAttributeValue(final String attributeId,
			final String attributeDataType, final String attributeValue,
			final RequestType request) {
		if (!NullChecker.isNullOrEmpty(attributeId)
				&& !NullChecker.isNullOrEmpty(attributeDataType)
				&& !NullChecker.isNullOrEmpty(attributeValue)
				&& !NullChecker.isNullOrEmpty(request)) {
			final List<String> attributeValues = new ArrayList<String>();
			attributeValues.add(attributeValue);
			XACMLContextUtil.addSubjectAttributeValues(attributeId,
					attributeDataType, attributeValues, request);
		}

	}

	/**
	 * @param attributeId
	 * @param attributeDataType
	 * @param attributeValues
	 * @param request
	 */
	public static void addSubjectAttributeValues(final String attributeId,
			final String attributeDataType, final List<String> attributeValues,
			final RequestType request) {
		if (!NullChecker.isNullOrEmpty(attributeId)
				&& !NullChecker.isNullOrEmpty(attributeDataType)
				&& (attributeValues != null)
				&& !NullChecker.isNullOrEmpty(request)) {
		}
		SubjectType st = request.getSubject().get(0);
		if (NullChecker.isNullOrEmpty(st)) {
			st = new SubjectType();
			request.getSubject().add(st);
		}

		final Iterator<String> attributeValuesIt = attributeValues.iterator();
		while (attributeValuesIt.hasNext()) {
			final String attributeValue = attributeValuesIt.next();
			if ((attributeValue == null)
					|| (attributeValue.trim().length() == 0)) {
				continue;
			}
			st.getAttribute().add(
					XACMLContextUtil.createAttributeValueType(attributeId,
							attributeDataType, attributeValue.trim()));
		}

	}

	private static AttributeType createAttributeValueType(
			final String attributeId, final String attributeDataType,
			final String attributeValue) {
		final AttributeValueType atv = new AttributeValueType();
		atv.getContent().add(attributeValue);

		final AttributeType at = new AttributeType();
		at.setAttributeId(attributeId);
		at.setDataType(attributeDataType);
		at.getAttributeValue().add(atv);

		return at;
	}

	/**
	 * @param request
	 * @param attributeId
	 * @return
	 */
	public static List<String> extractResourceAttributeValues(
			final RequestType request, final String attributeId) {
		return XACMLContextUtil.getResourceAttributeValues(request,
				attributeId, true);
	}

	/**
	 * @param request
	 * @param attributeId
	 * @return
	 */
	public static List<String> extractSubjectAttributeValues(
			final RequestType request, final String attributeId) {
		return XACMLContextUtil.getSubjectAttributeValues(request, attributeId,
				true);
	}

	/**
	 * @param request
	 * @param attributeId
	 * @return
	 */
	public static String getActionAttributeValue(final RequestType request,
			final String attributeId) {
		String retVal = "";

		if (!NullChecker.isNullOrEmpty(request)
				&& !NullChecker.isNullOrEmpty(request.getAction())
				&& !NullChecker.isNullOrEmpty(request.getAction()
						.getAttribute())) {
			final List<String> retVals = XACMLContextUtil.getAttributeValues(
					request.getAction().getAttribute(), attributeId, false);
			if (!NullChecker.isNullOrEmpty(retVals) && (retVals.get(0) != null)) {
				retVal = retVals.get(0).trim();
			}
		}
		return retVal;
	}

	private static List<String> getAttributeValues(
			final List<AttributeType> attributes, final String attributeId,
			final boolean removeAttr) {
		final List<String> retVal = new ArrayList<String>();
		if (NullChecker.isNullOrEmpty(attributes)
				|| NullChecker.isNullOrEmpty(attributeId)) {
			return retVal;
		}

		final List<AttributeType> deleteList = new ArrayList<AttributeType>();
		for (final AttributeType attribute : attributes) {
			if (attributeId.equalsIgnoreCase(attribute.getAttributeId())) {
				if (!NullChecker.isNullOrEmpty(attribute.getAttributeValue())
						&& !NullChecker.isNullOrEmpty(attribute
								.getAttributeValue().get(0))
						&& !NullChecker.isNullOrEmpty(attribute
								.getAttributeValue().get(0).getContent())) {
					final Object obj = attribute.getAttributeValue().get(0)
							.getContent().get(0);
					if (!NullChecker.isNullOrEmpty(obj)) {
						retVal.add(obj.toString().trim());
					}
				} // add to return list if value exists and is
					// non-null/non-empty
					// following will be true only for extract methods
				if (removeAttr) {
					deleteList.add(attribute);
				}
			} // if (attributeId.equalsIgnoreCase(attribute.getAttributeId())) {

		}

		// if deleteList exists, remove elements stored in delete list from
		// attributes List
		for (final AttributeType attributeForDeletion : deleteList) {
			attributes.remove(attributeForDeletion);
		}

		return retVal;
	}

	/**
	 * @param request
	 * @param attributeId
	 * @return
	 */
	public static List<String> getResourceAttributeValues(
			final RequestType request, final String attributeId) {
		return XACMLContextUtil.getResourceAttributeValues(request,
				attributeId, false);
	}

	private static List<String> getResourceAttributeValues(
			final RequestType request, final String attributeId,
			final boolean removeAttr) {
		final List<String> retVal = new ArrayList<String>();
		if (NullChecker.isNullOrEmpty(request)
				|| NullChecker.isNullOrEmpty(request.getResource())) {
			return retVal; // no resources, return empty list
		}
		final List<ResourceType> resourceTypeList = request.getResource();
		for (final ResourceType resourceType : resourceTypeList) {
			final List<String> resourceTypeAttributeValues = XACMLContextUtil
					.getAttributeValues(resourceType.getAttribute(),
							attributeId, removeAttr);
			if (!NullChecker.isNullOrEmpty(resourceTypeAttributeValues)) {
				retVal.addAll(resourceTypeAttributeValues);
			}
		} // iterate through ever resource. Should only be one
		return retVal;
	}

	/**
	 * @param request
	 * @param attributeId
	 * @return
	 */
	public static List<String> getSubjectAttributeValues(
			final RequestType request, final String attributeId) {
		return XACMLContextUtil.getSubjectAttributeValues(request, attributeId,
				false);
	}

	private static List<String> getSubjectAttributeValues(
			final RequestType request, final String attributeId,
			final boolean removeAttr) {
		final List<String> retVal = new ArrayList<String>();
		if (NullChecker.isNullOrEmpty(request)
				|| NullChecker.isNullOrEmpty(request.getSubject())) {
			return retVal; // no subjects, return empty list
		}
		final List<SubjectType> subjectTypeList = request.getSubject();
		for (final SubjectType subjectType : subjectTypeList) {
			final List<String> subjectAttributeValues = XACMLContextUtil
					.getAttributeValues(subjectType.getAttribute(),
							attributeId, removeAttr);
			if (!NullChecker.isNullOrEmpty(subjectAttributeValues)) {
				retVal.addAll(subjectAttributeValues);
			}
		} // iterate through every subject. Should only be one
		return retVal;
	}

	/**
	 * @param request
	 */
	public static void validateAndFixActionAttributes(final RequestType request) {
		if (!NullChecker.isNullOrEmpty(request)) {
			XACMLContextUtil.validateAndFixDataTypesInAttributes(request
					.getAction().getAttribute());
		}
	}

	// -----------------------------
	// Private
	// -----------------------------

	private static void validateAndFixDataTypesInAttributes(
			final List<AttributeType> attributeTypes) {
		for (final AttributeType attributeType : attributeTypes) {
			final String attributeDataType = attributeType.getDataType();
			// System.out.println("attributeDataType is null - " +
			// attributeDataType == null);

			// boolean nuoe = NullChecker.isNullOrEmpty(attributeDataType);
			if (NullChecker.isNullOrEmpty(attributeDataType)) {
				attributeType
						.setDataType(XACMLContextConstants.STRING_ATTR_DATA_TYPE);
			}
		}
	}

	/**
	 * @param request
	 */
	public static void validateAndFixResourceAttributes(
			final RequestType request) {
		if (!NullChecker.isNullOrEmpty(request)) {
			final List<ResourceType> resourceTypeList = request.getResource();

			final List<AttributeType> attributeTypes = new ArrayList<AttributeType>();
			for (final ResourceType resourceType : resourceTypeList) {
				attributeTypes.addAll(resourceType.getAttribute());
			} // iterate through every Resource
			XACMLContextUtil
					.validateAndFixDataTypesInAttributes(attributeTypes);
		}
	}

	/**
	 * @param request
	 */
	public static void validateAndFixSubjectAttributes(final RequestType request) {
		if (!NullChecker.isNullOrEmpty(request)) {
			final List<SubjectType> subjectTypeList = request.getSubject();

			final List<AttributeType> attributeTypes = new ArrayList<AttributeType>();
			for (final SubjectType subjectType : subjectTypeList) {
				attributeTypes.addAll(subjectType.getAttribute());
			} // iterate through every subject. Should only be one
			XACMLContextUtil
					.validateAndFixDataTypesInAttributes(attributeTypes);
		}
	}

}
