package gov.va.nvap.server.service.permission.common;

import java.util.logging.Level;
import java.util.logging.Logger;

public class PatientIdUtil {

	private static final Logger logger = Logger.getLogger(PatientIdUtil.class
			.getName());

	/**
	 * Parse an optionally HL7 V2 CX encoded patient identifier. If the patient
	 * identifier is not HL7 CX encoded, the original id will be returned. The
	 * format of an HL7 CX encoded patient id is
	 * "<id>^^^&<home coummunity id>&ISO"
	 * 
	 * @param receivedPatientId
	 *            Optionally HL7 encoded patient identifier
	 * @return Parsed patient id
	 */
	public static String parsePatientIdFromHL7CXType(
			final String receivedPatientId) {
		if (PatientIdUtil.logger.isLoggable(Level.FINEST)) {
			PatientIdUtil.logger.logp(Level.FINEST, "PatientIdUtil",
					"parsePatientIdFromHL7V2CXType", "Parsing patient id: ["
							+ receivedPatientId + "]");
		}

		String patientId = receivedPatientId;
		if ((patientId != null) && (patientId.length() > 0)) {
			// In some cases we see a quote - in others we do not. So lets strip
			// them off if we see them.
			// ---------------------------------------------------------------------------------------------
			if ((patientId.startsWith("'")) && (patientId.length() > 1)) {
				final StringBuffer sbPatientId = new StringBuffer(patientId);
				if (patientId.endsWith("'")) {
					sbPatientId.deleteCharAt(sbPatientId.length() - 1); // strip
																		// off
																		// the
																		// ending
																		// quote
				}
				sbPatientId.deleteCharAt(0); // strip off the first char quote

				patientId = sbPatientId.toString();
			}

			final int componentIndex = patientId.indexOf("^");

			if (componentIndex != -1) {
				patientId = patientId.substring(0, componentIndex);
			}

			if (PatientIdUtil.logger.isLoggable(Level.FINEST)) {
				PatientIdUtil.logger.logp(Level.FINEST, "PatientIdUtil",
						"parsePatientIdFromHL7V2CXType", "Parsed patient id: ["
								+ receivedPatientId + "]");
			}

		}
		return patientId;
	}
}
