package gov.va.nvap.server.service.pdq.transformer;

import gov.va.nvap.common.transformer.Transformer;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.validation.Assert;
import gov.va.nvap.privacy.ConsentType;
import gov.va.nvap.service.audit.ConsentAuditType;
import gov.va.nvap.service.audit.data.ConsentAudit;
import gov.va.nvap.service.pdq.RemovePatientCorrelationRequest;

import java.util.Date;

import org.springframework.beans.factory.annotation.Required;

/**
 * Convert the Patient demographics query to ConsentAudit.
 *
 * @author Asha Amritraj
 *
 */
public class PdqDocumentToConsentAudit implements
		Transformer<Object, ConsentAudit> {
	/**
	 * Inject home community Oid.
	 */
	String homeCommunityOid;

	@Required
	public void setHomeCommunityOid(final String homeCommunityOid) {
		this.homeCommunityOid = homeCommunityOid;
	}

	@Override
	public ConsentAudit transform(final Object object)
			throws TransformerException {

		String patientId = null;
		String userId = null;
		String detail = null;
		if (RemovePatientCorrelationRequest.class.isInstance(object)) {
			final RemovePatientCorrelationRequest request = (RemovePatientCorrelationRequest) object;
			patientId = request.getPatientId();
			userId = request.getUserId();
			detail = "ASSIGNING AUTHORITY:"
					+ request.getCorrelatedAssigningAuthorityName() + "/OID:"
					+ request.getCorrelatedAssigningAuthorityOid() + "/DFN:"
					+ request.getCorrelatedPatientId();
		} else {
			throw new TransformerException("Type not supported!");
		}

		Assert.assertNotEmpty(patientId, "Patient Id cannot be null");
		Assert.assertNotEmpty(userId, "User Id cannot be null");
		// Construct the consent audit
		final ConsentAudit consentAudit = new ConsentAudit();
		consentAudit.setActionType(ConsentAuditType.REVOKE_AUDIT_TYPE.value());
		consentAudit.setCreatedDate(new Date());
		consentAudit.setPatientId(patientId);
		consentAudit.setTimeOfEvent(new Date());
		consentAudit.setUserId(userId);
		consentAudit.setDetail(detail);
		consentAudit.setFacility(this.homeCommunityOid);
		// Temporary Fix to always use NW_HIN as this is the only place where we
		// can remove correlations.
		// TODO: Pass a service consumer context type as part of the request.
		consentAudit.setConsentType(ConsentType.NW_HIN_AUTHORIZATION.value());
		return consentAudit;
	}
}
