package gov.va.nvap.server.service.pdq.filter;

import gov.va.nvap.common.date.DateUtil;
import gov.va.nvap.common.filter.Filter;
import gov.va.nvap.common.filter.FilterException;
import gov.va.nvap.common.validation.NullChecker;

import java.util.Date;
import java.util.Map;
import java.util.Set;

/**
 * Get the response that has the most recent date.
 * 
 * @author Asha Amritraj
 * 
 */
public class MostRecentDateFilter implements
		Filter<Map<String, Map<String, Object>>, String> {

	@Override
	public String filter(final Map<String, Map<String, Object>> responses)
			throws FilterException {
		// Get responses
		final Set<String> keySet = responses.keySet();
		if (NullChecker.isEmpty(keySet)) {
			return null;
		}
		// If only one response, then return the response
		if (keySet.size() == 1) {
			for (final String key : keySet) {
				final Map<String, Object> properties = responses.get(key);
				if (NullChecker.isEmpty(properties)) {
					return null;
				} else {
					final Object rpcResponse = properties.get("rpcResponse");
					if (String.class.isInstance(rpcResponse)) {
						return (String) properties.get("rpcResponse");
					}
					return null;
				}
			}
		}
		// Get the most recent date
		Date mostRecentDate = null;
		String mostRecentFacility = null;
		for (final String key : keySet) {
			final Map<String, Object> record = responses.get(key);
			// Use the correlation date and the date last treated
			final Object lastCorrelatedDateObj = record.get("correlationDate");
			final Object lastTreatedDateObj = record.get("dateLastTreated");

			// JUN 01, 2007@10:40:01
			Date lastCorrelatedDate = null;
			Date lastTreatedDate = null;

			if (Date.class.isInstance(lastCorrelatedDateObj)) {
				lastCorrelatedDate = (Date) lastCorrelatedDateObj;
			}
			if (Date.class.isInstance(lastTreatedDateObj)) {
				lastTreatedDate = (Date) lastTreatedDateObj;
			}
			// Find the recent date
			Date recentDate = null;
			if (NullChecker.isNotEmpty(lastTreatedDate)
					&& NullChecker.isNotEmpty(lastCorrelatedDate)) {
				recentDate = DateUtil.getRecentDate(lastCorrelatedDate,
						lastTreatedDate);
			} else if (NullChecker.isNotEmpty(lastTreatedDate)) {
				recentDate = lastTreatedDate;
			} else if (NullChecker.isNotEmpty(lastCorrelatedDate)) {
				recentDate = lastCorrelatedDate;
			}
			// Get the most recently updated facility
			if (NullChecker.isEmpty(mostRecentDate)
					|| (recentDate != null && NullChecker.isNotEmpty(recentDate) && recentDate.after(mostRecentDate))) {
				mostRecentDate = recentDate;
				mostRecentFacility = key;
			}
		}
		// Return the RPC response
		if (NullChecker.isNotEmpty(mostRecentFacility)) {
			final Map<String, Object> facilityMap = responses
					.get(mostRecentFacility);
			if (NullChecker.isNotEmpty(facilityMap)) {
				// Get the response
				final Object response = facilityMap.get("rpcResponse");
				if (String.class.isInstance(response)) {
					return (String) facilityMap.get("rpcResponse");
				}
			}
		}
		return null;
	}
}
